import { SearchQueryDto } from '../../entities/base.entity';
import { EImageOrientation } from '../../enums/poster.enum';
import { FileUploadJSONDto } from '@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/file.dto';
import { UploadFileToStorageDto } from '../storage/storage.dto';
export declare class CreatePosterDTO extends FileUploadJSONDto {
    orientation: EImageOrientation;
    contentId: string;
}
declare const UpdatePosterDTO_base: import("@nestjs/common").Type<Partial<CreatePosterDTO>>;
export declare class UpdatePosterDTO extends UpdatePosterDTO_base {
}
declare const SearchPosterDTO_base: import("@nestjs/common").Type<SearchQueryDto<unknown> & UpdatePosterDTO>;
export declare class SearchPosterDTO extends SearchPosterDTO_base {
    providerId?: string;
    channelId?: string;
    providerName?: string;
    contentName?: string;
    channelName?: string;
}
export declare class PostersQueryDto {
    providerId?: string;
    contentId?: string;
    videoId?: string;
    channelId?: string;
    id?: string;
    isPublic?: boolean;
}
export declare class PosterQueryDto extends PostersQueryDto {
}
declare const PosterUploadDto_base: import("@nestjs/common").Type<Pick<UploadFileToStorageDto, "file" | "providerId"> & PostersQueryDto>;
export declare class PosterUploadDto extends PosterUploadDto_base {
    name?: string;
}
export {};
