"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PosterUploadDto = exports.PosterQueryDto = exports.PostersQueryDto = exports.SearchPosterDTO = exports.UpdatePosterDTO = exports.CreatePosterDTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const base_entity_1 = require("../../entities/base.entity");
const poster_enum_1 = require("../../enums/poster.enum");
const file_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/file.dto");
const storage_dto_1 = require("../storage/storage.dto");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
class CreatePosterDTO extends file_dto_1.FileUploadJSONDto {
}
exports.CreatePosterDTO = CreatePosterDTO;
__decorate([
    (0, swagger_1.ApiProperty)({ enum: poster_enum_1.EImageOrientation }),
    (0, class_validator_1.IsEnum)(poster_enum_1.EImageOrientation),
    __metadata("design:type", String)
], CreatePosterDTO.prototype, "orientation", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], CreatePosterDTO.prototype, "contentId", void 0);
class UpdatePosterDTO extends (0, swagger_1.PartialType)(CreatePosterDTO) {
}
exports.UpdatePosterDTO = UpdatePosterDTO;
class SearchPosterDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdatePosterDTO) {
}
exports.SearchPosterDTO = SearchPosterDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchPosterDTO.prototype, "providerId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchPosterDTO.prototype, "channelId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchPosterDTO.prototype, "providerName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchPosterDTO.prototype, "contentName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchPosterDTO.prototype, "channelName", void 0);
class PostersQueryDto {
}
exports.PostersQueryDto = PostersQueryDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.id == null &&
        o.videoId == null &&
        o.contentId == null &&
        o.channelId == null),
    __metadata("design:type", String)
], PostersQueryDto.prototype, "providerId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.id == null &&
        o.videoId == null &&
        o.channelId == null &&
        o.providerId == null),
    __metadata("design:type", String)
], PostersQueryDto.prototype, "contentId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.id == null &&
        o.contentId == null &&
        o.channelId == null &&
        o.providerId == null),
    __metadata("design:type", String)
], PostersQueryDto.prototype, "videoId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.id == null &&
        o.videoId == null &&
        o.contentId == null &&
        o.providerId == null),
    __metadata("design:type", String)
], PostersQueryDto.prototype, "channelId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.channelId == null &&
        o.videoId == null &&
        o.contentId == null &&
        o.providerId == null),
    __metadata("design:type", String)
], PostersQueryDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsBoolean)(),
    (0, la_nest_library_1.ToBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], PostersQueryDto.prototype, "isPublic", void 0);
class PosterQueryDto extends PostersQueryDto {
}
exports.PosterQueryDto = PosterQueryDto;
class PosterUploadDto extends (0, swagger_1.IntersectionType)((0, swagger_1.PickType)(storage_dto_1.UploadFileToStorageDto, ['file', 'providerId']), PostersQueryDto) {
}
exports.PosterUploadDto = PosterUploadDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], PosterUploadDto.prototype, "name", void 0);
//# sourceMappingURL=poster.dto.js.map