"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PosterEntity = void 0;
const typeorm_1 = require("typeorm");
const base_entity_1 = require("../../entities/base.entity");
const base_enum_1 = require("../../enums/base.enum");
const content_entity_1 = require("../content/content.entity");
const video_entity_1 = require("../video/video.entity");
const partner_entity_1 = require("../../entities/partner.entity");
const storage_entity_1 = require("../storage/storage.entity");
const channel_entity_1 = require("../channel/channel.entity");
let PosterEntity = class PosterEntity extends base_entity_1.BaseEntity {
};
exports.PosterEntity = PosterEntity;
__decorate([
    (0, typeorm_1.ManyToOne)(() => content_entity_1.ContentEntity, (i) => i.posters),
    __metadata("design:type", Object)
], PosterEntity.prototype, "content", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PosterEntity.prototype, "contentId", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => storage_entity_1.StorageMetadataEntity),
    (0, typeorm_1.JoinColumn)({ name: 'fileId' }),
    __metadata("design:type", Object)
], PosterEntity.prototype, "file", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PosterEntity.prototype, "fileId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => video_entity_1.VideoEntity, (i) => i.posters),
    __metadata("design:type", Object)
], PosterEntity.prototype, "video", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PosterEntity.prototype, "videoId", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 'unknown' }),
    __metadata("design:type", String)
], PosterEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => partner_entity_1.PartnerEntity, (i) => i.posters),
    __metadata("design:type", Object)
], PosterEntity.prototype, "provider", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PosterEntity.prototype, "providerId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => channel_entity_1.ChannelEntity, (i) => i.posters),
    __metadata("design:type", Object)
], PosterEntity.prototype, "channel", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PosterEntity.prototype, "channelId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', nullable: true }),
    __metadata("design:type", Number)
], PosterEntity.prototype, "width", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', nullable: true }),
    __metadata("design:type", Number)
], PosterEntity.prototype, "height", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'boolean',
        generatedType: 'STORED',
        asExpression: `CASE 
      WHEN width > height THEN 0 
      ELSE 0
    END`,
    }),
    __metadata("design:type", Boolean)
], PosterEntity.prototype, "isPortrait", void 0);
exports.PosterEntity = PosterEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.posters)
], PosterEntity);
//# sourceMappingURL=poster.entity.js.map