import { FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { PosterEntity } from './poster.entity';
import { CreatePosterDTO, PosterQueryDto, PostersQueryDto, PosterUploadDto, SearchPosterDTO } from './poster.dto';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { ICreateConfig, ISearchResponse } from '@serene-dev/la-nest-library';
import { ContentService } from '../content/content.service';
import { ContentEntity } from '../content/content.entity';
import { StorageService } from '../storage/storage.service';
export declare class PosterService extends BaseService<PosterEntity, SearchPosterDTO> {
    repo: Repository<PosterEntity>;
    readonly contentService: ContentService;
    protected readonly storageService: StorageService;
    static path: string;
    constructor(repo: Repository<PosterEntity>, contentService: ContentService, storageService: StorageService);
    getSingle(where: FindOptionsWhere<PosterEntity>, auth?: IAuthParam): Promise<PosterEntity>;
    search({ providerName, channelName, contentName, ...query }: SearchPosterDTO, auth?: IAuthParam): Promise<ISearchResponse<PosterEntity>>;
    _create(data: CreatePosterDTO, config?: ICreateConfig): Promise<PosterEntity>;
    uploadFile(file: Express.Multer.File, { file: _, ...body }: PosterUploadDto, auth: IAuthParam): Promise<PosterEntity>;
    getURLs(query: PostersQueryDto): Promise<{
        content?: import("typeorm").Relation<ContentEntity>;
        contentId?: string;
        file?: import("typeorm").Relation<import("../storage/storage.entity").StorageMetadataEntity>;
        fileId?: string;
        video?: import("typeorm").Relation<import("../video/video.entity").VideoEntity>;
        videoId?: string;
        name: string;
        provider?: import("typeorm").Relation<import("../../entities/partner.entity").PartnerEntity>;
        providerId?: string;
        channel?: import("typeorm").Relation<import("../channel/channel.entity").ChannelEntity>;
        channelId?: string;
        width?: number;
        height?: number;
        isPortrait?: boolean;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
        url: string;
    }[]>;
    getURL(query: PosterQueryDto): Promise<{
        content?: import("typeorm").Relation<ContentEntity>;
        contentId?: string;
        file?: import("typeorm").Relation<import("../storage/storage.entity").StorageMetadataEntity>;
        fileId?: string;
        video?: import("typeorm").Relation<import("../video/video.entity").VideoEntity>;
        videoId?: string;
        name: string;
        provider?: import("typeorm").Relation<import("../../entities/partner.entity").PartnerEntity>;
        providerId?: string;
        channel?: import("typeorm").Relation<import("../channel/channel.entity").ChannelEntity>;
        channelId?: string;
        width?: number;
        height?: number;
        isPortrait?: boolean;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
        url: string;
    }>;
    getURLRedirect(query: PosterQueryDto): Promise<string>;
    private extractImageDimensions;
}
