"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PosterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const poster_entity_1 = require("./poster.entity");
const base_enum_1 = require("../../enums/base.enum");
const utility_service_1 = require("../../services/utility.service");
const content_service_1 = require("../content/content.service");
const content_entity_1 = require("../content/content.entity");
const storage_service_1 = require("../storage/storage.service");
const storage_enum_1 = require("../../enums/storage.enum");
const sharp = require("sharp");
let PosterService = class PosterService extends base_service_1.BaseService {
    constructor(repo, contentService, storageService) {
        super(repo, base_enum_1.ETableName.posters);
        this.repo = repo;
        this.contentService = contentService;
        this.storageService = storageService;
    }
    async getSingle(where, auth) {
        const r = await this.repo.findOne({
            where,
            relations: {
                content: { channel: { provider: true } },
            },
        });
        return r;
    }
    search({ providerName, channelName, contentName, ...query }, auth) {
        return utility_service_1.UtilityClass.search(this.repo, query, {
            baseWhere: {
                content: {
                    name: utility_service_1.UtilityClass.likeFormatter(contentName),
                    channel: {
                        name: utility_service_1.UtilityClass.likeFormatter(channelName),
                        provider: { name: utility_service_1.UtilityClass.likeFormatter(providerName) },
                    },
                },
            },
            baseSelect: {
                content: {
                    name: true,
                    channel: { name: true, provider: { name: true } },
                },
            },
            baseRelations: {
                content: {
                    channel: {
                        provider: true,
                    },
                },
            },
        });
    }
    _create(data, config) {
        return super._create(data, config);
    }
    async uploadFile(file, { file: _, ...body }, auth) {
        if (body.contentId)
            await this.contentService.checkIfExistsById(body.contentId, {
                errorMessage: `Content not found`,
            });
        let image;
        await this.repo.manager.transaction(async (manager) => {
            const dimensions = await this.extractImageDimensions(file.buffer);
            const imageName = body.name ||
                (body.contentId
                    ? (await manager.findOne(content_entity_1.ContentEntity, {
                        where: { id: body.contentId },
                        select: { name: true },
                    }))?.name
                    : file.originalname);
            image = await manager.save(poster_entity_1.PosterEntity, this.repo.create(utility_service_1.UtilityClass.patchSearchWithOrg({
                ...body,
                orgID: body.providerId,
                creatorId: auth.id,
                name: imageName || 'Unknown',
                width: dimensions.width,
                height: dimensions.height,
            }, auth)));
            const uploadResult = await this.storageService.uploadFile({
                path: file.path,
                buffer: file.buffer,
                mimetype: file.mimetype,
                size: file.buffer.length,
                originalname: file.originalname,
            }, {
                fileType: storage_enum_1.EFileType.image,
                isPublic: body.isPublic,
                refCat: storage_enum_1.EFileRefCat.poster,
                refNo: image.id,
            }, {
                auth,
                entityManager: manager,
            });
            await manager.update(poster_entity_1.PosterEntity, { id: image.id }, { fileId: uploadResult.metadata.id });
        });
        return this.getSingle({ id: image.id }, auth);
    }
    async getURLs(query) {
        const posters = await this.repo.find({
            where: { ...query, fileId: (0, typeorm_2.Not)((0, typeorm_2.IsNull)()) },
            order: { order: 'ASC' },
        });
        return await Promise.all(posters.map((p) => this.storageService
            .generatePresignedUrl({ id: p.fileId })
            .then((r) => ({ url: r, ...p }))));
    }
    async getURL(query) {
        const p = await this.repo.findOne({
            where: { ...query, fileId: (0, typeorm_2.Not)((0, typeorm_2.IsNull)()) },
            order: { order: 'ASC' },
        });
        return await (p
            ? this.storageService
                .generatePresignedUrl({ id: p.fileId })
                .then((r) => ({ url: r, ...p }))
            : null);
    }
    async getURLRedirect(query) {
        const p = await this.repo.findOne({
            where: { ...query, fileId: (0, typeorm_2.Not)((0, typeorm_2.IsNull)()) },
            order: { order: 'ASC' },
            select: { fileId: true },
        });
        return await (p
            ? this.storageService.generatePresignedUrl({ id: p.fileId })
            : null);
    }
    async extractImageDimensions(buffer) {
        try {
            const metadata = await sharp(buffer).metadata();
            if (!metadata.width || !metadata.height) {
                throw new Error('Could not extract image dimensions');
            }
            return {
                width: metadata.width,
                height: metadata.height,
            };
        }
        catch (error) {
            console.error('Error extracting image metadata:', error);
            throw new Error(`Failed to extract image dimensions: ${error.message}`);
        }
    }
};
exports.PosterService = PosterService;
PosterService.path = `posters`;
exports.PosterService = PosterService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(poster_entity_1.PosterEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        content_service_1.ContentService,
        storage_service_1.StorageService])
], PosterService);
//# sourceMappingURL=poster.service.js.map