"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PricingEntity = exports.EDurationType = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const base_entity_1 = require("../../entities/base.entity");
const channel_pricing_entity_1 = require("../channel-pricing/channel-pricing.entity");
var EDurationType;
(function (EDurationType) {
    EDurationType["DAILY"] = "Daily";
    EDurationType["WEEKLY"] = "Weekly";
    EDurationType["MONTHLY"] = "Monthly";
    EDurationType["YEARLY"] = "Yearly";
})(EDurationType || (exports.EDurationType = EDurationType = {}));
var EDays;
(function (EDays) {
    EDays["day"] = "day";
    EDays["week"] = "week";
    EDays["month"] = "month";
    EDays["year"] = "year";
    EDays["days"] = "days";
})(EDays || (EDays = {}));
let PricingEntity = class PricingEntity extends base_entity_1.BaseEntity {
};
exports.PricingEntity = PricingEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], PricingEntity.prototype, "amount", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int' }),
    __metadata("design:type", Number)
], PricingEntity.prototype, "durationDays", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], PricingEntity.prototype, "isRecurrent", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'nvarchar',
        generatedType: 'STORED',
        asExpression: `
      CASE
        WHEN durationDays = 1 THEN '${EDays.day}'
        WHEN durationDays = 7 THEN '${EDays.week}'
        WHEN durationDays = 30 THEN '${EDays.month}'
        WHEN durationDays = 365 THEN '${EDays.year}'
        ELSE CONCAT(durationDays, ' ${EDays.days}')
      END
    `,
    }),
    __metadata("design:type", String)
], PricingEntity.prototype, "durationType", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'nvarchar',
        generatedType: 'STORED',
        asExpression: `
    CONCAT('₦',amount, ' / ',durationType)
    `,
    }),
    __metadata("design:type", String)
], PricingEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => channel_pricing_entity_1.ChannelPricingEntity, (i) => i.pricing),
    __metadata("design:type", Object)
], PricingEntity.prototype, "channelPricings", void 0);
exports.PricingEntity = PricingEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.pricings)
], PricingEntity);
//# sourceMappingURL=pricing.entity.js.map