import { Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { PricingEntity } from './pricing.entity';
import { SearchPricingDTO } from './pricing.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { ISearchResponse } from '@serene-dev/la-nest-library';
export declare class PricingService extends BaseService<PricingEntity, SearchPricingDTO> {
    repo: Repository<PricingEntity>;
    static path: string;
    constructor(repo: Repository<PricingEntity>);
    search({ amount, amountFrom, amountTo, name, ...query }: SearchPricingDTO, auth?: IAuthParam): Promise<ISearchResponse<PricingEntity>>;
}
