"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../../services/utility.service");
const jwt_auth_guard_1 = require("../authentication/guards/jwt-auth.guard");
const provider_service_1 = require("../../services/partner/provider.service");
const partner_dto_1 = require("../../dtos/partner.dto");
let ProviderController = class ProviderController {
    constructor(clientService) {
        this.clientService = clientService;
    }
    async getWallet(auth) {
        try {
            const wallet = await this.clientService.getOrCreateWallet(auth.id);
            return utility_service_1.UtilityClass.handleSuccess({
                data: {
                    grossBalance: wallet.grossBalance,
                    netBalance: wallet.netBalance,
                    grossTotalCredit: wallet.grossTotalCredit,
                    grossTotalDebit: wallet.grossTotalDebit,
                    netTotalCredit: wallet.netTotalCredit,
                    netTotalDebit: wallet.netTotalDebit,
                },
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ProviderController = ProviderController;
__decorate([
    (0, common_1.Get)(`wallet`),
    (0, swagger_1.ApiResponse)({ type: partner_dto_1.GetClientWalletDto }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProviderController.prototype, "getWallet", null);
exports.ProviderController = ProviderController = __decorate([
    (0, jwt_auth_guard_1.AllowProviderKey)(),
    (0, swagger_1.ApiTags)('PROVIDER'),
    (0, common_1.Controller)('provider'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [provider_service_1.ProviderService])
], ProviderController);
//# sourceMappingURL=provider.controller.js.map