"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderModule = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const shared_service_1 = require("../../services/shared.service");
const partner_entity_1 = require("../../entities/partner.entity");
const provider_controller_1 = require("./provider.controller");
const axios_1 = require("@nestjs/axios");
const api_service_1 = require("../../services/api.service");
const token_session_entity_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/entities/token-session.entity");
const provider_service_1 = require("../../services/partner/provider.service");
const index_entities_1 = require("../../entities/index.entities");
let ProviderModule = class ProviderModule extends la_nest_library_1.BaseModule {
};
exports.ProviderModule = ProviderModule;
ProviderModule.controllers = [provider_controller_1.ProviderController];
ProviderModule.services = [...shared_service_1.SharedServices, provider_service_1.ProviderService, api_service_1.APIService];
ProviderModule.entities = [partner_entity_1.PartnerEntity, token_session_entity_1.TokenSessionEntity, ...index_entities_1.views];
exports.ProviderModule = ProviderModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [
            la_nest_library_1.SDKWalletModule,
            typeorm_1.TypeOrmModule.forFeature(ProviderModule.entities),
            axios_1.HttpModule,
            la_nest_library_1.LoggerDBModule,
        ],
        providers: [...ProviderModule.services],
        exports: [...ProviderModule.services],
        controllers: ProviderModule.controllers,
    })
], ProviderModule);
//# sourceMappingURL=provider.module.js.map