import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { IDDto } from '@serene-dev/la-nest-library';
import { HttpService } from '@nestjs/axios';
import { Response } from 'express';
import { StorageService } from './storage.service';
import { UploadFileToStorageDto, SearchStorageDto, GeneratePresignedUrlDto } from './storage.dto';
export declare class StorageController {
    private readonly storageService;
    private readonly httpService;
    constructor(storageService: StorageService, httpService: HttpService);
    uploadFile(file: Express.Multer.File, body: UploadFileToStorageDto, auth: IAuthParam): Promise<string | {
        key: string;
        url: string;
        metadata: import("./storage.entity").StorageMetadataEntity;
    }>;
    search(query: SearchStorageDto, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<import("./storage.entity").StorageMetadataEntity>>;
    deleteFile(id: string, auth: IAuthParam): Promise<unknown>;
    generatePresignedUrl(query: GeneratePresignedUrlDto, auth: IAuthParam, response: Response): Promise<void | Response<any, Record<string, any>>>;
    getById(param: IDDto, auth: IAuthParam): Promise<string | {
        url: string;
        refNo: string;
        key: string;
        refCat: import("../../enums/storage.enum").EFileRefCat;
        fileType: import("../../enums/storage.enum").EFileType;
        length?: number;
        resolution?: number;
        isPortrait?: boolean;
        originalName?: string;
        mimeType: string;
        isPublic: boolean;
        size?: number;
        description?: string;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
    }>;
    updateFileMetadata(param: IDDto, updateData: UploadFileToStorageDto, auth: IAuthParam): Promise<string | {
        url: string;
        refNo: string;
        key: string;
        refCat: import("../../enums/storage.enum").EFileRefCat;
        fileType: import("../../enums/storage.enum").EFileType;
        length?: number;
        resolution?: number;
        isPortrait?: boolean;
        originalName?: string;
        mimeType: string;
        isPublic: boolean;
        size?: number;
        description?: string;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
    }>;
}
