"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const platform_express_1 = require("@nestjs/platform-express");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../../services/utility.service");
const axios_1 = require("@nestjs/axios");
const storage_service_1 = require("./storage.service");
const storage_dto_1 = require("./storage.dto");
const search_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/search.dto");
let StorageController = class StorageController {
    constructor(storageService, httpService) {
        this.storageService = storageService;
        this.httpService = httpService;
    }
    async uploadFile(file, body, auth) {
        try {
            const result = await this.storageService.uploadFile(file, body, { auth });
            return utility_service_1.UtilityClass.handleSuccess({ data: result });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async search(query, auth) {
        try {
            const result = await this.storageService.searchFileMetadata(query, auth);
            return utility_service_1.UtilityClass.handleSuccess({ data: result });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async deleteFile(id, auth) {
        try {
            await this.storageService.deleteFile({ id }, auth);
            return utility_service_1.UtilityClass.handleSuccess({
                message: 'File deleted successfully',
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async generatePresignedUrl(query, auth, response) {
        try {
            const url = await this.storageService.generatePresignedUrl(query, auth);
            if (!url) {
                return response.status(404).json({ message: 'URL not found' });
            }
            return response.redirect(url);
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getById(param, auth) {
        try {
            const data = await this.storageService.getFileMetadata(param, auth);
            return utility_service_1.UtilityClass.handleSuccess({ data });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async updateFileMetadata(param, updateData, auth) {
        try {
            const updatedMetadata = await this.storageService.updateFileMetadata(param.id, updateData, { auth });
            return utility_service_1.UtilityClass.handleSuccess({ data: updatedMetadata });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.StorageController = StorageController;
__decorate([
    (0, common_1.Post)('upload'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, swagger_1.ApiBody)({ type: storage_dto_1.UploadFileToStorageDto }),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, storage_dto_1.UploadFileToStorageDto, Object]),
    __metadata("design:returntype", Promise)
], StorageController.prototype, "uploadFile", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [storage_dto_1.SearchStorageDto, Object]),
    __metadata("design:returntype", Promise)
], StorageController.prototype, "search", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], StorageController.prototype, "deleteFile", null);
__decorate([
    (0, common_1.Get)('url'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __param(2, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [storage_dto_1.GeneratePresignedUrlDto, Object, Object]),
    __metadata("design:returntype", Promise)
], StorageController.prototype, "generatePresignedUrl", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], StorageController.prototype, "getById", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        storage_dto_1.UploadFileToStorageDto, Object]),
    __metadata("design:returntype", Promise)
], StorageController.prototype, "updateFileMetadata", null);
exports.StorageController = StorageController = __decorate([
    (0, swagger_1.ApiTags)('storage'),
    (0, common_1.Controller)('storage'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [storage_service_1.StorageService,
        axios_1.HttpService])
], StorageController);
//# sourceMappingURL=storage.controller.js.map