"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetVideoByResolutionDto = exports.SearchStorageDto = exports.GeneratePresignedUrlDto = exports.UpdateFileMetaDto = exports.UploadFileToStorageDto = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const swagger_2 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const base_entity_1 = require("../../entities/base.entity");
const storage_enum_1 = require("../../enums/storage.enum");
const common_1 = require("@nestjs/common");
class UploadFileToStorageDto {
}
exports.UploadFileToStorageDto = UploadFileToStorageDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Whether the file is publicly accessible',
    }),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, la_nest_library_1.ToBoolean)(),
    __metadata("design:type", Boolean)
], UploadFileToStorageDto.prototype, "isPublic", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "refNo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.ValidateIf)((o) => o.fileType && o.fileType != storage_enum_1.EFileType.image),
    __metadata("design:type", Number)
], UploadFileToStorageDto.prototype, "length", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], UploadFileToStorageDto.prototype, "resolution", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: storage_enum_1.EFileRefCat }),
    (0, class_validator_1.IsEnum)(storage_enum_1.EFileRefCat),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "refCat", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: storage_enum_1.EFileType }),
    (0, class_validator_1.IsEnum)(storage_enum_1.EFileType),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "fileType", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "originalName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', format: 'binary' }),
    __metadata("design:type", Object)
], UploadFileToStorageDto.prototype, "file", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "path", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "fileName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "providerId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UploadFileToStorageDto.prototype, "id", void 0);
class UpdateFileMetaDto extends (0, swagger_2.OmitType)((0, swagger_2.PartialType)(UploadFileToStorageDto), ['file', 'providerId']) {
}
exports.UpdateFileMetaDto = UpdateFileMetaDto;
class GeneratePresignedUrlDto {
}
exports.GeneratePresignedUrlDto = GeneratePresignedUrlDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], GeneratePresignedUrlDto.prototype, "id", void 0);
class SearchStorageDto extends (0, swagger_2.IntersectionType)(base_entity_1.SearchQueryDto, UpdateFileMetaDto) {
}
exports.SearchStorageDto = SearchStorageDto;
class GetVideoByResolutionDto {
}
exports.GetVideoByResolutionDto = GetVideoByResolutionDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'URL of the video to query',
    }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], GetVideoByResolutionDto.prototype, "url", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Width of the video in pixels',
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], GetVideoByResolutionDto.prototype, "width", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Height of the video in pixels',
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], GetVideoByResolutionDto.prototype, "height", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Height of the video in pixels',
        default: 90,
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.Max)(100),
    (0, class_validator_1.Min)(10),
    (0, common_1.Optional)(),
    __metadata("design:type", Number)
], GetVideoByResolutionDto.prototype, "quality", void 0);
//# sourceMappingURL=storage.dto.js.map