import { Repository } from 'typeorm';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { StorageMetadataEntity } from './storage.entity';
import { ICreateConfig } from '../../interfaces/index.interface';
import { UploadFileToStorageDto, UpdateFileMetaDto, SearchStorageDto, GetVideoByResolutionDto } from './storage.dto';
export declare class StorageService {
    private repo;
    static path: string;
    private s3Client;
    readonly bucket: string;
    readonly url: string;
    protected readonly expiresIn: 3600;
    readonly linksCache: {
        set: (key: string, value: {
            link: string;
            expiresIn?: number;
            key: string;
            isPublic: boolean;
            orgID: string;
            creatorId: string;
        }) => void;
        delete: (key: string) => void;
        get: (key: string) => {
            link: string;
            expiresIn?: number;
            key: string;
            isPublic: boolean;
            orgID: string;
            creatorId: string;
        };
        has: (key: string) => boolean;
        trim: () => void;
        destroy: () => void;
    };
    readonly userAccessCache: {
        set: (key: string, value: boolean) => void;
        delete: (key: string) => void;
        get: (key: string) => boolean;
        has: (key: string) => boolean;
        trim: () => void;
        destroy: () => void;
    };
    constructor(repo: Repository<StorageMetadataEntity>);
    private ensureBucketExists;
    uploadFile(file: Pick<Express.Multer.File, 'path' | 'buffer' | 'mimetype' | 'size' | 'originalname'>, meta: Omit<UploadFileToStorageDto, 'file'>, config: ICreateConfig): Promise<{
        key: string;
        url: string;
        metadata: StorageMetadataEntity;
    }>;
    deleteFile(query: Partial<StorageMetadataEntity>, auth: IAuthParam): Promise<void>;
    checkAccessToFile(file: {
        id: string;
    } & Partial<StorageMetadataEntity>, auth: IAuthParam): Promise<void>;
    updateFileMetadata(id: string, update: UpdateFileMetaDto, config: ICreateConfig): Promise<{
        url: string;
        refNo: string;
        key: string;
        refCat: import("../../enums/storage.enum").EFileRefCat;
        fileType: import("../../enums/storage.enum").EFileType;
        length?: number;
        resolution?: number;
        isPortrait?: boolean;
        originalName?: string;
        mimeType: string;
        isPublic: boolean;
        size?: number;
        description?: string;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
    }>;
    generatePresignedUrl(query: Partial<StorageMetadataEntity>, auth?: IAuthParam): Promise<string>;
    convertToResolution(query: GetVideoByResolutionDto): string;
    getFileMetadata(query: Partial<StorageMetadataEntity>, auth?: IAuthParam): Promise<{
        url: string;
        refNo: string;
        key: string;
        refCat: import("../../enums/storage.enum").EFileRefCat;
        fileType: import("../../enums/storage.enum").EFileType;
        length?: number;
        resolution?: number;
        isPortrait?: boolean;
        originalName?: string;
        mimeType: string;
        isPublic: boolean;
        size?: number;
        description?: string;
        lastUpdateID?: string;
        id?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
    }>;
    searchFileMetadata({ originalName, description, orgID, ...query }: SearchStorageDto, auth?: IAuthParam): Promise<import("@serene-dev/la-nest-library").ISearchResponse<StorageMetadataEntity>>;
    getFileFromCloudflare(query: Partial<Pick<StorageMetadataEntity, 'key' | 'id'>>): Promise<Buffer>;
    saveFileToFileSystem(fileBuffer: Buffer, filePath: string): Promise<void>;
}
