import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { IDDto } from '@serene-dev/la-nest-library';
import { SubscriptionEntity } from './subscription.entity';
import { CreateSubscriptionDTO, SearchSubscriptionDTO, SubAccessCheckDto, UpdateRenewalDto, UpdateSubscriptionDTO } from './subscription.dto';
import { SubscriptionService } from './subscription.service';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
export declare class SubscriptionController extends BaseCRUDController<SubscriptionEntity, SearchSubscriptionDTO> {
    protected service: SubscriptionService;
    constructor(service: SubscriptionService);
    search(query: SearchSubscriptionDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<SubscriptionEntity>>;
    userHasAccess(query: SubAccessCheckDto, auth?: IAuthParam): Promise<string | boolean>;
    updateRenewal(param: IDDto, body: UpdateRenewalDto, auth?: IAuthParam): Promise<string | import("typeorm").UpdateResult>;
    create(body: CreateSubscriptionDTO, auth: IAuthParam): string | Promise<SubscriptionEntity>;
    updateByID(param: IDDto, body: UpdateSubscriptionDTO, auth: IAuthParam): string | Promise<SubscriptionEntity>;
}
