"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubAccessCheckDto = exports.SearchSubscriptionDTO = exports.UpdateRenewalDto = exports.UpdateSubscriptionDTO = exports.CreateSubscriptionDTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const base_entity_1 = require("../../entities/base.entity");
const pricing_dto_1 = require("../pricing/pricing.dto");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
class CreateSubscriptionDTO {
}
exports.CreateSubscriptionDTO = CreateSubscriptionDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateSubscriptionDTO.prototype, "userAuthId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], CreateSubscriptionDTO.prototype, "channelPricingId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateSubscriptionDTO.prototype, "transReference", void 0);
class UpdateSubscriptionDTO extends (0, swagger_1.PartialType)(CreateSubscriptionDTO) {
}
exports.UpdateSubscriptionDTO = UpdateSubscriptionDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, la_nest_library_1.ToBoolean)(),
    __metadata("design:type", Boolean)
], UpdateSubscriptionDTO.prototype, "noRenewal", void 0);
class UpdateRenewalDto extends (0, swagger_1.PickType)(UpdateSubscriptionDTO, [
    'noRenewal',
]) {
}
exports.UpdateRenewalDto = UpdateRenewalDto;
class SearchSubscriptionDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdateSubscriptionDTO, (0, swagger_1.PickType)(pricing_dto_1.SearchPricingDTO, [
    'amount',
    'amountFrom',
    'amountTo',
    'durationDays',
    'isRecurrent',
])) {
}
exports.SearchSubscriptionDTO = SearchSubscriptionDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "providerId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "channelName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "providerName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "pricingId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "channelId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "firstname", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "lastname", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SearchSubscriptionDTO.prototype, "phoneNumber", void 0);
class SubAccessCheckDto {
}
exports.SubAccessCheckDto = SubAccessCheckDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.channelId != null ||
        (o.contentId == null && o.contentScheduleId == null)),
    __metadata("design:type", String)
], SubAccessCheckDto.prototype, "channelId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.contentScheduleId != null ||
        (o.channelId == null && o.contentId == null)),
    __metadata("design:type", String)
], SubAccessCheckDto.prototype, "contentScheduleId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.contentId != null ||
        (o.channelId == null && o.contentScheduleId == null)),
    __metadata("design:type", String)
], SubAccessCheckDto.prototype, "contentId", void 0);
//# sourceMappingURL=subscription.dto.js.map