import { FindOptionsRelations, FindOptionsSelect, FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { SubscriptionEntity } from './subscription.entity';
import { CreateSubscriptionDTO, SearchSubscriptionDTO, SubAccessCheckDto, UpdateRenewalDto } from './subscription.dto';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { ISearchResponse } from '@serene-dev/la-nest-library';
import { ChannelPricingService } from '../channel-pricing/channel-pricing.service';
import { PaystackService } from '../../services/paystack.service';
import { PricingEntity } from '../pricing/pricing.entity';
export declare class SubscriptionService extends BaseService<SubscriptionEntity, SearchSubscriptionDTO> {
    repo: Repository<SubscriptionEntity>;
    channelPricingService: ChannelPricingService;
    paystackService: PaystackService;
    static path: string;
    protected readonly relation: FindOptionsRelations<SubscriptionEntity>;
    protected readonly relationSelect: FindOptionsSelect<SubscriptionEntity>;
    constructor(repo: Repository<SubscriptionEntity>, channelPricingService: ChannelPricingService, paystackService: PaystackService);
    protected checkPending(): Promise<void>;
    toggleRenewal(subId: string, body: UpdateRenewalDto, auth: IAuthParam): Promise<import("typeorm").UpdateResult>;
    sendForVerification(pricing: PricingEntity, sub: SubscriptionEntity): void;
    computeEndDate(verificationDate?: number, durationDays?: number): number;
    getSingle(where: FindOptionsWhere<SubscriptionEntity>, auth?: IAuthParam): Promise<SubscriptionEntity>;
    userHasAccess(userAuthId: string, query: SubAccessCheckDto): Promise<boolean>;
    userAccessStatus(userAuthId: string, query: SubAccessCheckDto): Promise<SubscriptionEntity>;
    search({ channelName, providerName, amount, amountFrom, amountTo, firstname, lastname, email, phoneNumber, ...query }: SearchSubscriptionDTO, auth?: IAuthParam): Promise<ISearchResponse<SubscriptionEntity>>;
    protected _postCreateFunction(requestData: CreateSubscriptionDTO, savedData: SubscriptionEntity): Promise<void>;
    protected checkOutdatedSubscriptions(): Promise<void>;
}
