"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const subscription_entity_1 = require("./subscription.entity");
const utility_service_1 = require("../../services/utility.service");
const base_enum_1 = require("../../enums/base.enum");
const channel_pricing_service_1 = require("../channel-pricing/channel-pricing.service");
const paystack_service_1 = require("../../services/paystack.service");
const subscription_enum_1 = require("./subscription.enum");
const schedule_1 = require("@nestjs/schedule");
const index_config_1 = require("../../configs/index.config");
const authentication_enum_1 = require("../authentication/enums/authentication.enum");
let SubscriptionService = class SubscriptionService extends base_service_1.BaseService {
    constructor(repo, channelPricingService, paystackService) {
        super(repo, base_enum_1.ETableName.subscriptions);
        this.repo = repo;
        this.channelPricingService = channelPricingService;
        this.paystackService = paystackService;
        this.relation = {
            channelPricing: {
                channel: {
                    provider: true,
                },
                pricing: true,
            },
            userAuth: {
                detail: true,
            },
        };
        this.relationSelect = {
            channelPricing: {
                id: true,
                channel: {
                    name: true,
                    id: true,
                    provider: {
                        id: true,
                        name: true,
                    },
                },
                pricing: { durationDays: true, id: true, amount: true, name: true },
            },
            userAuth: {
                firstname: true,
                lastname: true,
                email: true,
                detail: {
                    phoneNumber: true,
                },
            },
        };
        this.paystackService.verifyPaystackComplete$.subscribe(() => {
            this.checkPending();
        });
        setTimeout(() => {
            this.checkOutdatedSubscriptions();
        }, 3000);
    }
    async checkPending() {
        const pending = await this.repo.find({
            where: { status: subscription_enum_1.EVerificationStatus.pending },
            relations: { channelPricing: { pricing: true } },
        });
        pending?.forEach((p) => {
            this.sendForVerification(p.channelPricing.pricing, p);
        });
    }
    async toggleRenewal(subId, body, auth) {
        return await this.repo.update(utility_service_1.UtilityClass.patchSearchWithOwner({ id: subId }, auth, 'userAuthId'), { noRenewal: body.noRenewal });
    }
    sendForVerification(pricing, sub) {
        this.paystackService.addToVerification({
            reference: sub.transReference,
            cb: (status) => this.repo.update({ id: sub.id }, { status, verificationDate: Date.now() }),
            pricing,
        });
    }
    computeEndDate(verificationDate, durationDays) {
        return verificationDate && durationDays
            ? verificationDate + durationDays * index_config_1.Config.TimeStampDay
            : null;
    }
    async getSingle(where, auth) {
        const r = await this.repo.findOne({
            where: utility_service_1.UtilityClass.patchSearchWithOwner(where, auth, 'userAuthId'),
            relations: this.relation,
            select: this.relationSelect,
        });
        if (r)
            r['renewalDate'] = this.computeEndDate(r?.verificationDate, r?.channelPricing?.pricing?.durationDays);
        return r;
    }
    async userHasAccess(userAuthId, query) {
        return await this.repo.existsBy({
            userAuthId,
            active: true,
            status: subscription_enum_1.EVerificationStatus.verified,
            expiredDate: (0, typeorm_2.IsNull)(),
            channelPricing: {
                channelId: query.channelId ?? null,
                channel: { contents: { id: query.contentId ?? null } },
            },
        });
    }
    async userAccessStatus(userAuthId, query) {
        return await this.getSingle({
            userAuthId,
            active: true,
            expiredDate: (0, typeorm_2.IsNull)(),
            channelPricing: {
                channelId: query.channelId ?? null,
                channel: { contents: { id: query.contentId ?? null } },
            },
        }, { id: userAuthId, userType: authentication_enum_1.EAuthType.public, token: null });
    }
    search({ channelName, providerName, amount, amountFrom, amountTo, firstname, lastname, email, phoneNumber, ...query }, auth) {
        return utility_service_1.UtilityClass.search(this.repo, query, {
            baseWhere: {
                channelPricing: {
                    channel: {
                        name: utility_service_1.UtilityClass.likeFormatter(channelName),
                        provider: { name: utility_service_1.UtilityClass.likeFormatter(providerName) },
                    },
                    pricing: {
                        amount: utility_service_1.UtilityClass.computeRangeQuery(amount, amountFrom, amountTo),
                    },
                },
                userAuth: {
                    firstname: utility_service_1.UtilityClass.likeFormatter(firstname),
                    lastname: utility_service_1.UtilityClass.likeFormatter(lastname),
                    email: utility_service_1.UtilityClass.likeFormatter(email),
                    detail: {
                        phoneNumber: utility_service_1.UtilityClass.likeFormatter(phoneNumber),
                    },
                },
            },
            baseRelations: this.relation,
            baseSelect: this.relationSelect,
        });
    }
    async _postCreateFunction(requestData, savedData) {
        this.sendForVerification((await this.repo.findOne({
            where: { id: savedData.id },
            relations: { channelPricing: { pricing: true } },
        })).channelPricing.pricing, savedData);
    }
    async checkOutdatedSubscriptions() {
        try {
            console.log('Running daily check for outdated subscriptions');
            const activeSubscriptions = await this.repo.find({
                where: {
                    active: true,
                    status: subscription_enum_1.EVerificationStatus.verified,
                    expiredDate: (0, typeorm_2.IsNull)(),
                },
                relations: {
                    channelPricing: {
                        pricing: true,
                    },
                },
                select: {
                    id: true,
                    verificationDate: true,
                    channelPricing: {
                        id: true,
                        pricing: { id: true, durationDays: true },
                    },
                },
            });
            const now = Date.now();
            console.log(`Checking ${activeSubscriptions.length} for outdated subscriptions on`, now);
            let updatedCount = 0;
            for (const sub of activeSubscriptions) {
                const endDate = this.computeEndDate(sub.verificationDate, sub.channelPricing?.pricing?.durationDays);
                if (endDate == null)
                    continue;
                if (this.computeEndDate(sub.verificationDate, sub.channelPricing?.pricing?.durationDays) <= now) {
                    await this.repo.update({ id: sub.id }, { active: false, expiredDate: now });
                    updatedCount++;
                }
            }
            console.log(`Updated ${updatedCount} outdated subscriptions`);
        }
        catch (error) {
            console.error('Error during subscription check:', error);
        }
    }
};
exports.SubscriptionService = SubscriptionService;
SubscriptionService.path = `subscriptions`;
__decorate([
    (0, schedule_1.Cron)('0 0 * * *'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SubscriptionService.prototype, "checkOutdatedSubscriptions", null);
exports.SubscriptionService = SubscriptionService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(subscription_entity_1.SubscriptionEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        channel_pricing_service_1.ChannelPricingService,
        paystack_service_1.PaystackService])
], SubscriptionService);
//# sourceMappingURL=subscription.service.js.map