"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VideoQualities = exports.VideoQualityMapping = void 0;
const video_enum_1 = require("./video.enum");
exports.VideoQualityMapping = {
    [video_enum_1.EVideoQuality.low]: { width: 640, height: 360 },
    [video_enum_1.EVideoQuality.sd]: { width: 720, height: 576 },
    [video_enum_1.EVideoQuality.hd]: { width: 1280, height: 720 },
    [video_enum_1.EVideoQuality.fhd]: { width: 1920, height: 1080 },
    [video_enum_1.EVideoQuality.qhd]: {
        width: 2560,
        height: 1440,
    },
    [video_enum_1.EVideoQuality.uhd]: { width: 3840, height: 2160 },
    [video_enum_1.EVideoQuality.fourK]: {
        width: 4096,
        height: 2160,
    },
    [video_enum_1.EVideoQuality.eightK]: {
        width: 7680,
        height: 4320,
    },
};
exports.VideoQualities = Object.entries(exports.VideoQualityMapping)
    .map((x) => ({
    quality: x[0],
    ...x[1],
}))
    .sort((a, b) => b.height - a.height);
//# sourceMappingURL=video.config.js.map