import { VideoService } from './video.service';
import { BaseController } from '../../controllers/base.controller';
import { VideoEntity } from './video.entity';
import { GenerateVideoUrlDto, SearchVideoDTO, VideoUploadDto } from './video.dto';
import { IDDto } from '@serene-dev/la-nest-library';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { Response } from 'express';
export declare class VideoController extends BaseController<VideoEntity, SearchVideoDTO> {
    protected service: VideoService;
    constructor(service: VideoService);
    uploadFile(file: Express.Multer.File, body: VideoUploadDto, auth: IAuthParam): Promise<string | VideoEntity>;
    generatePresignedUrl(query: GenerateVideoUrlDto, auth: IAuthParam, response: Response): Promise<void | Response<any, Record<string, any>>>;
    reprocess(param: IDDto, auth: IAuthParam): Promise<string | {
        message: string;
    }>;
}
