"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VideoController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const jwt_auth_guard_1 = require("../authentication/guards/jwt-auth.guard");
const video_service_1 = require("./video.service");
const base_controller_1 = require("../../controllers/base.controller");
const video_dto_1 = require("./video.dto");
const platform_express_1 = require("@nestjs/platform-express");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../../services/utility.service");
const authentication_enum_1 = require("../authentication/enums/authentication.enum");
let VideoController = class VideoController extends base_controller_1.BaseController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async uploadFile(file, body, auth) {
        try {
            const result = await this.service.uploadFile(file, body, auth);
            return utility_service_1.UtilityClass.handleSuccess({ data: result });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async generatePresignedUrl(query, auth, response) {
        try {
            const url = await this.service.generatePresignedUrl(query, auth);
            if (!url) {
                return response.status(404).json({ message: 'URL not found' });
            }
            return response.redirect(url);
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async reprocess(param, auth) {
        try {
            if (auth.userType == authentication_enum_1.EAuthType.provider)
                await this.service.checkIfExistsBy({
                    id: param.id,
                    orgID: auth.providerId,
                });
            const result = await this.service.reProcessVideo(param.id);
            return utility_service_1.UtilityClass.handleSuccess({ data: result });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.VideoController = VideoController;
__decorate([
    (0, common_1.Post)('upload'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, video_dto_1.VideoUploadDto, Object]),
    __metadata("design:returntype", Promise)
], VideoController.prototype, "uploadFile", null);
__decorate([
    (0, common_1.Get)('url'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __param(2, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [video_dto_1.GenerateVideoUrlDto, Object, Object]),
    __metadata("design:returntype", Promise)
], VideoController.prototype, "generatePresignedUrl", null);
__decorate([
    (0, common_1.Post)('reprocess'),
    (0, jwt_auth_guard_1.Role)([authentication_enum_1.EAuthType.admin, authentication_enum_1.EAuthType.provider]),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], VideoController.prototype, "reprocess", null);
exports.VideoController = VideoController = __decorate([
    (0, jwt_auth_guard_1.AllowProviderKey)(),
    (0, swagger_1.ApiTags)(video_service_1.VideoService.tag),
    (0, common_1.Controller)(video_service_1.VideoService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [video_service_1.VideoService])
], VideoController);
//# sourceMappingURL=video.controller.js.map