import { FileUpdateDto, FileUploadJSONDto } from '@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/file.dto';
import { VideoEntity } from './video.entity';
import { SearchQueryDto } from '@serene-dev/la-nest-library';
import { UploadFileToStorageDto } from '../storage/storage.dto';
import { EVideoQuality } from './video.enum';
export declare class VideoBaseDto implements Partial<VideoEntity> {
    length: number;
    isPortrait: boolean;
}
declare const VideoUploadJSONDto_base: import("@nestjs/common").Type<VideoBaseDto & FileUploadJSONDto>;
export declare class VideoUploadJSONDto extends VideoUploadJSONDto_base implements Partial<VideoEntity> {
}
declare const VideoUploadDto_base: import("@nestjs/common").Type<Pick<UploadFileToStorageDto, "file" | "providerId">>;
export declare class VideoUploadDto extends VideoUploadDto_base {
    contentId?: string;
    name?: string;
}
declare const UpdateVideoDTO_base: import("@nestjs/common").Type<Partial<VideoUploadJSONDto & FileUpdateDto>>;
export declare class UpdateVideoDTO extends UpdateVideoDTO_base {
}
declare const SearchVideoDTO_base: import("@nestjs/common").Type<SearchQueryDto<unknown> & UpdateVideoDTO>;
export declare class SearchVideoDTO extends SearchVideoDTO_base implements Partial<VideoEntity> {
}
export interface IQualityVersion {
    quality: EVideoQuality;
    width: number;
    height: number;
}
export declare class GenerateVideoUrlDto {
    videoId?: string;
    fileId?: string;
    qualityId?: string;
}
export {};
