"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenerateVideoUrlDto = exports.SearchVideoDTO = exports.UpdateVideoDTO = exports.VideoUploadDto = exports.VideoUploadJSONDto = exports.VideoBaseDto = void 0;
const file_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/file.dto");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const class_validator_1 = require("class-validator");
const class_transformer_1 = require("class-transformer");
const storage_dto_1 = require("../storage/storage.dto");
class VideoBaseDto {
}
exports.VideoBaseDto = VideoBaseDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], VideoBaseDto.prototype, "length", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, la_nest_library_1.ToBoolean)(),
    __metadata("design:type", Boolean)
], VideoBaseDto.prototype, "isPortrait", void 0);
class VideoUploadJSONDto extends (0, swagger_1.IntersectionType)(file_dto_1.FileUploadJSONDto, VideoBaseDto) {
}
exports.VideoUploadJSONDto = VideoUploadJSONDto;
class VideoUploadDto extends (0, swagger_1.PickType)(storage_dto_1.UploadFileToStorageDto, [
    'file',
    'providerId',
]) {
}
exports.VideoUploadDto = VideoUploadDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], VideoUploadDto.prototype, "contentId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], VideoUploadDto.prototype, "name", void 0);
class UpdateVideoDTO extends (0, swagger_1.PartialType)((0, swagger_1.IntersectionType)(file_dto_1.FileUpdateDto, VideoUploadJSONDto)) {
}
exports.UpdateVideoDTO = UpdateVideoDTO;
class SearchVideoDTO extends (0, swagger_1.IntersectionType)(la_nest_library_1.SearchQueryDto, UpdateVideoDTO) {
}
exports.SearchVideoDTO = SearchVideoDTO;
class GenerateVideoUrlDto {
}
exports.GenerateVideoUrlDto = GenerateVideoUrlDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.fileId == null),
    __metadata("design:type", String)
], GenerateVideoUrlDto.prototype, "videoId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.videoId == null),
    __metadata("design:type", String)
], GenerateVideoUrlDto.prototype, "fileId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.ValidateIf)((o) => o.videoId == null),
    __metadata("design:type", String)
], GenerateVideoUrlDto.prototype, "qualityId", void 0);
//# sourceMappingURL=video.dto.js.map