import { Relation } from 'typeorm';
import { EVideoProcStatus, EVideoQuality } from './video.enum';
import { ContentEntity } from '../content/content.entity';
import { BaseEntity } from '../../entities/base.entity';
import { StorageMetadataEntity } from '../storage/storage.entity';
import { PosterEntity } from '../poster/poster.entity';
declare class VideoSharedColumns extends BaseEntity {
    processingStatus: EVideoProcStatus;
    quality: EVideoQuality;
    qualityScore: number;
    width?: number;
    height?: number;
}
export declare class VideoEntity extends VideoSharedColumns {
    name: string;
    contents?: Relation<ContentEntity[]>;
    posters?: Relation<PosterEntity[]>;
    readonly isPortrait: boolean;
    isStreamed: boolean;
    processingProgress?: number;
    length?: number;
    sourceFilePath?: string;
    versions?: Relation<VideoVersionEntity[]>;
    sourceVersion?: Relation<VideoVersionEntity>;
    sourceVersionId?: string;
}
export declare class VideoVersionEntity extends VideoSharedColumns {
    streamChunks?: Relation<VideoContentChunkEntity>[];
    meta?: Relation<VideoEntity>;
    metaId: string;
    isSource: boolean;
    file?: Relation<StorageMetadataEntity>;
    fileId?: string;
}
export declare class VideoContentChunkEntity {
    id: string;
    size: number;
    length: number;
    startTime: number;
    endTime: number;
    parent?: Relation<VideoVersionEntity>;
    parentId: string;
    dataURI?: string;
    createdAt?: string;
    deletedAt?: Date;
    updatedAt?: string;
}
export {};
