"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VideoContentChunkEntity = exports.VideoVersionEntity = exports.VideoEntity = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const video_enum_1 = require("./video.enum");
const content_entity_1 = require("../content/content.entity");
const base_entity_1 = require("../../entities/base.entity");
const storage_entity_1 = require("../storage/storage.entity");
const poster_entity_1 = require("../poster/poster.entity");
class VideoSharedColumns extends base_entity_1.BaseEntity {
}
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: video_enum_1.EVideoProcStatus,
        default: video_enum_1.EVideoProcStatus.pending,
    }),
    __metadata("design:type", String)
], VideoSharedColumns.prototype, "processingStatus", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: video_enum_1.EVideoQuality, nullable: true }),
    __metadata("design:type", String)
], VideoSharedColumns.prototype, "quality", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'double',
        generatedType: 'STORED',
        asExpression: `CASE 
      WHEN quality = '${video_enum_1.EVideoQuality.low}' THEN 1
      WHEN quality = '${video_enum_1.EVideoQuality.sd}' THEN 2
      WHEN quality = '${video_enum_1.EVideoQuality.hd}' THEN 3
      WHEN quality = '${video_enum_1.EVideoQuality.fhd}' THEN 4
      WHEN quality = '${video_enum_1.EVideoQuality.uhd}' THEN 5
      WHEN quality = '${video_enum_1.EVideoQuality.fourK}' THEN 6
      WHEN quality = '${video_enum_1.EVideoQuality.eightK}' THEN 7
      ELSE 0
    END`,
    }),
    __metadata("design:type", Number)
], VideoSharedColumns.prototype, "qualityScore", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', nullable: true }),
    __metadata("design:type", Number)
], VideoSharedColumns.prototype, "width", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', nullable: true }),
    __metadata("design:type", Number)
], VideoSharedColumns.prototype, "height", void 0);
let VideoEntity = class VideoEntity extends VideoSharedColumns {
};
exports.VideoEntity = VideoEntity;
__decorate([
    (0, typeorm_1.Column)({}),
    __metadata("design:type", String)
], VideoEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => content_entity_1.ContentEntity, (i) => i.video, { cascade: ['insert'] }),
    __metadata("design:type", Object)
], VideoEntity.prototype, "contents", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => poster_entity_1.PosterEntity, (i) => i.content),
    __metadata("design:type", Object)
], VideoEntity.prototype, "posters", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'boolean',
        generatedType: 'STORED',
        asExpression: `CASE 
      WHEN width > height THEN 0 
      ELSE 0
    END`,
    }),
    __metadata("design:type", Boolean)
], VideoEntity.prototype, "isPortrait", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Boolean)
], VideoEntity.prototype, "isStreamed", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', default: 0 }),
    __metadata("design:type", Number)
], VideoEntity.prototype, "processingProgress", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', nullable: true }),
    __metadata("design:type", Number)
], VideoEntity.prototype, "length", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], VideoEntity.prototype, "sourceFilePath", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => VideoVersionEntity, (i) => i.meta),
    __metadata("design:type", Object)
], VideoEntity.prototype, "versions", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => VideoVersionEntity),
    (0, typeorm_1.JoinColumn)({ name: 'sourceVersionId' }),
    __metadata("design:type", Object)
], VideoEntity.prototype, "sourceVersion", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], VideoEntity.prototype, "sourceVersionId", void 0);
exports.VideoEntity = VideoEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.videos)
], VideoEntity);
let VideoVersionEntity = class VideoVersionEntity extends VideoSharedColumns {
};
exports.VideoVersionEntity = VideoVersionEntity;
__decorate([
    (0, typeorm_1.OneToMany)(() => VideoContentChunkEntity, (i) => i.parent),
    __metadata("design:type", Array)
], VideoVersionEntity.prototype, "streamChunks", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => VideoEntity, (i) => i.versions),
    __metadata("design:type", Object)
], VideoVersionEntity.prototype, "meta", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], VideoVersionEntity.prototype, "metaId", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'boolean',
        default: false,
    }),
    __metadata("design:type", Boolean)
], VideoVersionEntity.prototype, "isSource", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => storage_entity_1.StorageMetadataEntity),
    __metadata("design:type", Object)
], VideoVersionEntity.prototype, "file", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], VideoVersionEntity.prototype, "fileId", void 0);
exports.VideoVersionEntity = VideoVersionEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.video_versions)
], VideoVersionEntity);
let VideoContentChunkEntity = class VideoContentChunkEntity {
};
exports.VideoContentChunkEntity = VideoContentChunkEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], VideoContentChunkEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], VideoContentChunkEntity.prototype, "size", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], VideoContentChunkEntity.prototype, "length", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], VideoContentChunkEntity.prototype, "startTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], VideoContentChunkEntity.prototype, "endTime", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => VideoVersionEntity, (i) => i.streamChunks),
    __metadata("design:type", Object)
], VideoContentChunkEntity.prototype, "parent", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], VideoContentChunkEntity.prototype, "parentId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'longblob', nullable: true }),
    __metadata("design:type", String)
], VideoContentChunkEntity.prototype, "dataURI", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp' }),
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", String)
], VideoContentChunkEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.DeleteDateColumn)(),
    __metadata("design:type", Date)
], VideoContentChunkEntity.prototype, "deletedAt", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp' }),
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", String)
], VideoContentChunkEntity.prototype, "updatedAt", void 0);
exports.VideoContentChunkEntity = VideoContentChunkEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.videoContentChunks)
], VideoContentChunkEntity);
//# sourceMappingURL=video.entity.js.map