"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VideoModule = exports.videoUploadDirectory = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const shared_service_1 = require("../../services/shared.service");
const partner_entity_1 = require("../../entities/partner.entity");
const video_controller_1 = require("./video.controller");
const axios_1 = require("@nestjs/axios");
const api_service_1 = require("../../services/api.service");
const token_session_entity_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/entities/token-session.entity");
const provider_service_1 = require("../../services/partner/provider.service");
const video_service_1 = require("./video.service");
const video_entity_1 = require("./video.entity");
const view_history_entity_1 = require("../view-history/view-history.entity");
const view_history_controller_1 = require("../view-history/view-history.controller");
const view_history_service_1 = require("../view-history/view-history.service");
const file_module_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/file/file.module");
const authentication_module_1 = require("../authentication/authentication.module");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
const fs_1 = require("fs");
const path_1 = require("path");
exports.videoUploadDirectory = (0, path_1.join)(__dirname, '../../uploads/video');
console.log('videoUploadDirectory __dirname', __dirname);
console.log('videoUploadDirectory', exports.videoUploadDirectory);
if (!(0, fs_1.existsSync)(exports.videoUploadDirectory)) {
    (0, fs_1.mkdirSync)(exports.videoUploadDirectory, { recursive: true });
}
let VideoModule = class VideoModule extends la_nest_library_1.BaseModule {
};
exports.VideoModule = VideoModule;
VideoModule.controllers = [video_controller_1.VideoController, view_history_controller_1.ViewHistoryController];
VideoModule.services = [
    ...shared_service_1.SharedServices,
    provider_service_1.ProviderService,
    api_service_1.APIService,
    video_service_1.VideoService,
    view_history_service_1.ViewHistoryService,
];
VideoModule.entities = [
    partner_entity_1.PartnerEntity,
    token_session_entity_1.TokenSessionEntity,
    video_entity_1.VideoEntity,
    video_entity_1.VideoVersionEntity,
    video_entity_1.VideoContentChunkEntity,
    view_history_entity_1.ViewHistoryEntity,
    view_history_entity_1.ViewHistoryChunkEntity,
];
exports.VideoModule = VideoModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [
            la_nest_library_1.SDKWalletModule,
            typeorm_1.TypeOrmModule.forFeature(VideoModule.entities),
            axios_1.HttpModule,
            file_module_1.FileModule,
            la_nest_library_1.LoggerDBModule,
            authentication_module_1.AuthenticationModule,
            platform_express_1.MulterModule.register({
                storage: (0, multer_1.diskStorage)({
                    destination: (req, file, cb) => {
                        try {
                            if (!(0, fs_1.existsSync)(exports.videoUploadDirectory)) {
                                (0, fs_1.mkdirSync)(exports.videoUploadDirectory, { recursive: true });
                            }
                            cb(null, exports.videoUploadDirectory);
                        }
                        catch (error) {
                            cb(new Error(`Failed to create upload directory: ${error.message}`), null);
                        }
                    },
                    filename: (req, file, cb) => {
                        try {
                            if (!file.mimetype.startsWith('video/')) {
                                return cb(new Error('Only video files are allowed'), null);
                            }
                            if (file.size > 100 * 1024 * 1024) {
                                return cb(new Error('File size too large'), null);
                            }
                            cb(null, file.originalname);
                        }
                        catch (error) {
                            cb(new Error(`Failed to process filename: ${error.message}`), null);
                        }
                    },
                }),
            }),
        ],
        providers: [...VideoModule.services],
        exports: [...VideoModule.services],
        controllers: VideoModule.controllers,
    })
], VideoModule);
//# sourceMappingURL=video.module.js.map