import { FindOptionsWhere, Repository } from 'typeorm';
import { VideoVersionEntity, VideoEntity } from './video.entity';
import { BaseService } from '../../services/base.service';
import { GenerateVideoUrlDto, SearchVideoDTO, VideoUploadDto } from './video.dto';
import { StorageService } from '../storage/storage.service';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { ContentService } from '../content/content.service';
import { Subject } from 'rxjs';
export declare class VideoService extends BaseService<VideoEntity, SearchVideoDTO> {
    readonly repo: Repository<VideoEntity>;
    readonly repoVideoVersion: Repository<VideoVersionEntity>;
    protected readonly storageService: StorageService;
    protected readonly contentService: ContentService;
    static path: string;
    protected readonly triggerProcess$: Subject<string | void>;
    protected readonly processingQueue: Map<string, {
        reprocess?: boolean;
    }>;
    constructor(repo: Repository<VideoEntity>, repoVideoVersion: Repository<VideoVersionEntity>, storageService: StorageService, contentService: ContentService);
    uploadFile(file: Express.Multer.File, { contentId, ...body }: VideoUploadDto, auth: IAuthParam): Promise<VideoEntity>;
    generatePresignedUrl(query: GenerateVideoUrlDto, auth: IAuthParam): Promise<string>;
    getSingle(where: FindOptionsWhere<VideoEntity>, auth?: IAuthParam): Promise<VideoEntity>;
    protected checkForUnprocessed(): Promise<void>;
    processVideo(videoId: string): void;
    reProcessVideo(videoId: string): {
        message: string;
    };
    protected _processVideo(): Promise<void>;
    private extractVideoMetadata;
    private calculateResolutions;
    protected cleanupOldVideoFiles(): Promise<void>;
    private determineVideoQuality;
    private checkFfmpegInstallation;
    private convertVideoResolution;
    private createVideoDirectory;
    private generateVideoFilename;
    protected cleanupEmptyDirectories(): Promise<void>;
}
