"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VideoService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const video_entity_1 = require("./video.entity");
const base_service_1 = require("../../services/base.service");
const storage_service_1 = require("../storage/storage.service");
const base_enum_1 = require("../../enums/base.enum");
const content_service_1 = require("../content/content.service");
const utility_service_1 = require("../../services/utility.service");
const content_entity_1 = require("../content/content.entity");
const rxjs_1 = require("rxjs");
const schedule_1 = require("@nestjs/schedule");
const video_enum_1 = require("./video.enum");
const video_module_1 = require("./video.module");
const video_config_1 = require("./video.config");
const fs = require("fs/promises");
const path = require("path");
const ffprobe = require("ffprobe");
const ffmpeg = require("fluent-ffmpeg");
const ffprobeStatic = require("ffprobe-static");
const authentication_enum_1 = require("../authentication/enums/authentication.enum");
const storage_enum_1 = require("../../enums/storage.enum");
const child_process_1 = require("child_process");
let VideoService = class VideoService extends base_service_1.BaseService {
    constructor(repo, repoVideoVersion, storageService, contentService) {
        super(repo, base_enum_1.ETableName.videos);
        this.repo = repo;
        this.repoVideoVersion = repoVideoVersion;
        this.storageService = storageService;
        this.contentService = contentService;
        this.triggerProcess$ = new rxjs_1.Subject();
        this.processingQueue = new Map();
        this.triggerProcess$
            .pipe((0, rxjs_1.tap)((id) => id && !this.processingQueue.has(id)
            ? this.processingQueue.set(id, {})
            : null), (0, rxjs_1.debounceTime)(1000), (0, rxjs_1.exhaustMap)(() => this._processVideo()))
            .subscribe(() => {
            if (this.processingQueue.size)
                this.triggerProcess$.next();
        });
        setTimeout(() => {
            this.checkForUnprocessed();
        }, 3000);
        this.checkFfmpegInstallation();
    }
    async uploadFile(file, { contentId, ...body }, auth) {
        if (contentId)
            await this.contentService.checkIfExistsById(contentId, {
                errorMessage: `Content not found`,
            });
        let video;
        await this.repo.manager.transaction(async (manager) => {
            const videoName = body.name ||
                (contentId
                    ? (await manager.findOne(content_entity_1.ContentEntity, {
                        where: { id: contentId },
                        select: { name: true },
                    }))?.name
                    : file.originalname);
            video = await manager.save(video_entity_1.VideoEntity, this.repo.create(utility_service_1.UtilityClass.patchSearchWithOrg({
                sourceFilePath: file.path,
                orgID: body.providerId,
                creatorId: auth.id,
                name: videoName || 'Unknown',
            }, auth)));
            if (contentId)
                await manager.update(content_entity_1.ContentEntity, { id: contentId }, { videoId: video.id });
        });
        this.processVideo(video.id);
        return this.getSingle({ id: video.id }, auth);
    }
    async generatePresignedUrl(query, auth) {
        const fileId = query.fileId ??
            (query.qualityId
                ? (await this.repoVideoVersion.findOne({
                    where: { id: query.qualityId },
                    select: { fileId: true },
                }))?.fileId
                : query.videoId
                    ? (await this.repoVideoVersion.findOne({
                        where: { metaId: query.videoId, isSource: true },
                        select: { fileId: true },
                    }))?.fileId
                    : null);
        if (!fileId)
            utility_service_1.UtilityClass.throwError({ statusCode: 404 });
        return await this.storageService.generatePresignedUrl({ id: fileId }, auth);
    }
    getSingle(where, auth) {
        utility_service_1.UtilityClass.patchSearchWithOrg(where, auth);
        return this.repo.findOne({
            where,
            relations: { versions: true },
        });
    }
    async checkForUnprocessed() {
        console.log('cron checking for videos to process from db');
        const unproc = await this.repo.find({
            select: { id: true },
            where: {
                processingStatus: (0, typeorm_2.In)([
                    video_enum_1.EVideoProcStatus.failed,
                    video_enum_1.EVideoProcStatus.pending,
                    video_enum_1.EVideoProcStatus.processing,
                ]),
                id: (0, typeorm_2.Not)((0, typeorm_2.In)(Array.from(this.processingQueue.keys()))),
            },
        });
        console.log('found ', unproc);
        unproc?.forEach((x) => {
            this.processVideo(x.id);
        });
    }
    processVideo(videoId) {
        this.triggerProcess$.next(videoId);
    }
    reProcessVideo(videoId) {
        this.processingQueue.set(videoId, { reprocess: true });
        this.triggerProcess$.next(videoId);
        return { message: `Triggered reprocessing` };
    }
    async _processVideo() {
        console.log('checking for videos to process');
        const videoId = Array.from(this.processingQueue)[0][0];
        console.log('found video to process', videoId);
        try {
            const config = this.processingQueue.get(videoId);
            if (videoId)
                this.processingQueue.delete(videoId);
            const video = await this.repo.findOne({
                where: { id: videoId },
                relations: { versions: { file: true } },
            });
            if (!config.reprocess &&
                video.processingStatus == video_enum_1.EVideoProcStatus.complete)
                return;
            await this.repo.update({ id: videoId }, {
                processingStatus: video_enum_1.EVideoProcStatus.processing,
                processingProgress: 0,
                sourceVersionId: null,
            });
            const sourceFilePath = video.sourceFilePath;
            let sourceFileExists = false;
            if (sourceFilePath) {
                try {
                    await fs.access(sourceFilePath);
                    sourceFileExists = true;
                }
                catch (error) {
                    console.log(`Source file not found at path: ${sourceFilePath}`);
                    sourceFileExists = false;
                }
            }
            console.log('sourceFileExists', sourceFileExists, sourceFilePath);
            if (!sourceFilePath || !sourceFileExists) {
                const nearestFile = video.versions.find((x) => x.isSource && x.fileId) ??
                    video.versions.sort2('qualityScore').find((x) => !!x.fileId);
                if (nearestFile?.fileId) {
                    console.log(`Source file not found locally. Attempting to retrieve from provider: ${nearestFile.fileId}`);
                    try {
                        let fileBuffer = await this.storageService.getFileFromCloudflare({
                            id: nearestFile.fileId,
                        });
                        const sourceFilePath = `${video_module_1.videoUploadDirectory}/${video.id}_${Date.now()}.${nearestFile.file?.mimeType?.split('/')[1] ?? 'mp4'}`;
                        await this.storageService.saveFileToFileSystem(fileBuffer, sourceFilePath);
                        fileBuffer = null;
                        await this.repo.update({ id: video.id }, { sourceFilePath: sourceFilePath });
                        console.log(`Successfully retrieved file from Cloudflare and saved to ${sourceFilePath}`);
                        video.sourceFilePath = sourceFilePath;
                    }
                    catch (cloudflareError) {
                        console.error('Failed to retrieve file from Cloudflare:', cloudflareError);
                        throw new Error('Source file path not found and Cloudflare retrieval failed');
                    }
                }
                else {
                    throw new Error('Source file path not found and no Cloudflare ID available');
                }
            }
            const fileMetadata = await this.extractVideoMetadata(video.sourceFilePath);
            console.log('File metadata:', fileMetadata);
            const stats = await fs.stat(video.sourceFilePath);
            const fileName = path.basename(video.sourceFilePath);
            await this.repoVideoVersion.delete({ metaId: videoId });
            const sourceVersion = await this.repoVideoVersion.save(this.repoVideoVersion.create({
                metaId: videoId,
                isSource: true,
                quality: this.determineVideoQuality(fileMetadata.height),
                processingStatus: video_enum_1.EVideoProcStatus.processing,
                width: fileMetadata.width,
                height: fileMetadata.height,
            }));
            const uploadResult = await this.storageService.uploadFile({
                path: video.sourceFilePath,
                buffer: null,
                mimetype: fileMetadata.mimeType,
                size: stats.size,
                originalname: fileName,
            }, {
                fileType: storage_enum_1.EFileType.video,
                isPublic: false,
                refCat: storage_enum_1.EFileRefCat.video,
                refNo: sourceVersion.id,
                length: fileMetadata.duration,
                path: videoId,
                fileName: `${sourceVersion.quality}`,
            }, {
                auth: {
                    id: video.creatorId,
                    providerId: video.orgID,
                    userType: authentication_enum_1.EAuthType.admin,
                    token: null,
                },
            });
            await this.repoVideoVersion.update({ id: sourceVersion.id }, this.repoVideoVersion.create({
                processingStatus: video_enum_1.EVideoProcStatus.complete,
                fileId: uploadResult.metadata.id,
            }));
            const qualityVersions = this.calculateResolutions(fileMetadata.width, fileMetadata.height);
            await this.repo.update({ id: videoId }, this.repo.create({
                sourceVersionId: sourceVersion.id,
                length: fileMetadata.duration,
                height: fileMetadata.height,
                width: fileMetadata.width,
                quality: this.determineVideoQuality(fileMetadata.height),
                processingProgress: (1 / (qualityVersions.length + 1)) * 100,
            }));
            if (false) {
                const videoDir = await this.createVideoDirectory(video.id);
                await (0, rxjs_1.lastValueFrom)((0, rxjs_1.concat)(...qualityVersions.map((version, index) => new rxjs_1.Observable((sub) => {
                    const func = async () => {
                        const outputFilename = this.generateVideoFilename(path.basename(video.sourceFilePath), video.id, version.quality);
                        const outputPath = path.join(videoDir, outputFilename);
                        const conversionResult = await this.convertVideoResolution(video.sourceFilePath, outputPath, version.height, version.width);
                        const qualityVersion = await this.repoVideoVersion.save(this.repoVideoVersion.create({
                            metaId: videoId,
                            quality: version.quality,
                            processingStatus: video_enum_1.EVideoProcStatus.processing,
                            width: version.width,
                            height: version.height,
                        }));
                        const uploadResult = await this.storageService.uploadFile({
                            path: conversionResult.path,
                            buffer: null,
                            mimetype: fileMetadata.mimeType,
                            size: conversionResult.size,
                            originalname: version.quality + fileName,
                        }, {
                            fileType: storage_enum_1.EFileType.video,
                            isPublic: false,
                            refCat: storage_enum_1.EFileRefCat.video,
                            refNo: qualityVersion.id,
                            length: fileMetadata.duration,
                            path: videoId,
                            fileName: `${qualityVersion.quality}`,
                        }, {
                            auth: {
                                id: video.creatorId,
                                providerId: video.orgID,
                                userType: authentication_enum_1.EAuthType.admin,
                                token: null,
                            },
                        });
                        await this.repoVideoVersion.update({ id: qualityVersion.id }, this.repoVideoVersion.create({
                            processingStatus: video_enum_1.EVideoProcStatus.complete,
                            fileId: uploadResult.metadata.id,
                        }));
                        await this.repo.update({ id: videoId }, this.repo.create({
                            processingProgress: ((1 + index + 1) / (qualityVersions.length + 1)) *
                                100,
                            processingStatus: index == qualityVersions.length - 1
                                ? video_enum_1.EVideoProcStatus.complete
                                : video_enum_1.EVideoProcStatus.processing,
                        }));
                        return qualityVersion;
                    };
                    func().then((r) => {
                        sub.next();
                        sub.complete();
                    });
                }))));
            }
            await this.repo.update({ id: videoId }, this.repo.create({
                processingStatus: video_enum_1.EVideoProcStatus.complete,
                processingProgress: 100,
            }));
        }
        catch (error) {
            console.error('processing error', videoId, error);
            await this.repo.update({ id: videoId }, { processingStatus: video_enum_1.EVideoProcStatus.failed });
        }
    }
    async extractVideoMetadata(filePath) {
        try {
            console.log('filePath', filePath);
            await fs.access(filePath);
            console.log('filePath accessed');
            const info = await ffprobe(filePath, { path: ffprobeStatic.path });
            console.log('filePath probed', info);
            const videoStream = info.streams.find((stream) => stream.codec_type === 'video');
            console.log('videoStream', videoStream);
            if (!videoStream) {
                throw new Error('No video stream found in file');
            }
            const format = path.extname(filePath).substring(1);
            console.log('format', format);
            return {
                width: videoStream.width,
                height: videoStream.height,
                duration: parseFloat(videoStream.duration || '0'),
                format: format,
                mimeType: `video/${format}`,
            };
        }
        catch (error) {
            console.error('Error extracting video metadata:', error);
            throw error;
        }
    }
    calculateResolutions(originalWidth, originalHeight) {
        const aspectRatio = originalWidth / originalHeight;
        const resolutions = Object.entries(video_config_1.VideoQualityMapping).map(([quality, config]) => ({
            quality: quality,
            height: config.height,
            width: Math.round(config.height * aspectRatio),
        }));
        return resolutions
            .filter((res) => res.width < originalWidth && res.height < originalHeight)
            .sort((a, b) => b.height - a.height);
    }
    async cleanupOldVideoFiles() {
        console.log('Running monthly cleanup of old video files');
        try {
            const files = await fs.readdir(video_module_1.videoUploadDirectory);
            const now = new Date();
            const oneMonthAgo = new Date(now.setMonth(now.getMonth() - 1));
            let deletedCount = 0;
            for (const file of files) {
                const filePath = path.join(video_module_1.videoUploadDirectory, file);
                try {
                    const stats = await fs.stat(filePath);
                    if (stats.ctime < oneMonthAgo) {
                        await fs.unlink(filePath);
                        deletedCount++;
                    }
                }
                catch (fileError) {
                    console.error(`Error processing file ${filePath}:`, fileError);
                }
            }
            console.log(`Cleanup complete: deleted ${deletedCount} old video files`);
        }
        catch (error) {
            console.error('Error during video file cleanup:', error);
        }
    }
    determineVideoQuality(height) {
        const matchedQuality = video_config_1.VideoQualities.find((quality) => height >= quality.height);
        return matchedQuality?.quality || video_enum_1.EVideoQuality.low;
    }
    async checkFfmpegInstallation() {
        try {
            await new Promise((resolve, reject) => {
                const ffmpegProcess = (0, child_process_1.spawn)('ffmpeg', ['-version']);
                ffmpegProcess.on('message', (e) => {
                    console.log('ffmeg', e);
                });
                ffmpegProcess.on('error', (err) => {
                    if (err['code'] === 'ENOENT') {
                        reject(new Error('FFmpeg is not installed. Please install FFmpeg to process videos.'));
                    }
                    else {
                        reject(err);
                    }
                });
                ffmpegProcess.on('close', (code) => {
                    if (code === 0) {
                        resolve(true);
                    }
                    else {
                        reject(new Error(`FFmpeg check failed with code ${code}`));
                    }
                });
            });
        }
        catch (error) {
            console.error('FFmpeg check failed:', error);
        }
    }
    async convertVideoResolution(inputPath, outputPath, targetHeight, targetWidth) {
        try {
            await new Promise((resolve, reject) => {
                const bitrate = targetHeight >= 1440
                    ? '4096k'
                    : targetHeight >= 1080
                        ? '2048k'
                        : '1024k';
                ffmpeg(inputPath)
                    .size(`${targetWidth}x${targetHeight}`)
                    .videoBitrate(bitrate)
                    .videoCodec('libx264')
                    .outputOptions([
                    '-preset fast',
                    '-movflags +faststart',
                    '-profile:v main',
                    '-level 4.1',
                ])
                    .on('start', (commandLine) => {
                    console.log('Started ffmpeg with command:', commandLine);
                })
                    .on('progress', (progress) => {
                    console.log('Processing: ' + progress.percent + '% done');
                })
                    .on('end', () => resolve(outputPath))
                    .on('error', (err) => {
                    console.error('FFmpeg error:', err);
                    reject(new Error(`Video conversion failed: ${err.message}`));
                })
                    .save(outputPath);
            });
            const stats = await fs.stat(outputPath);
            return {
                path: outputPath,
                size: stats.size,
            };
        }
        catch (error) {
            console.error('Error in video conversion:', error);
        }
    }
    async createVideoDirectory(videoId) {
        const videoDir = path.join(video_module_1.videoUploadDirectory, videoId);
        try {
            await fs.access(videoDir);
        }
        catch {
            await fs.mkdir(videoDir, { recursive: true });
        }
        return videoDir;
    }
    generateVideoFilename(originalName, videoId, quality) {
        const extension = path.extname(originalName);
        const timestamp = Date.now();
        const qualitySuffix = quality ? `_${quality}` : '';
        return `${videoId}${qualitySuffix}_${timestamp}${extension}`;
    }
    async cleanupEmptyDirectories() {
        try {
            const dirs = await fs.readdir(video_module_1.videoUploadDirectory);
            for (const dir of dirs) {
                const dirPath = path.join(video_module_1.videoUploadDirectory, dir);
                try {
                    const files = await fs.readdir(dirPath);
                    if (files.length === 0) {
                        await fs.rmdir(dirPath);
                        console.log(`Removed empty directory: ${dirPath}`);
                    }
                }
                catch (error) {
                    console.error(`Error processing directory ${dirPath}:`, error);
                }
            }
        }
        catch (error) {
            console.error('Error during empty directory cleanup:', error);
        }
    }
};
exports.VideoService = VideoService;
VideoService.path = 'videos';
__decorate([
    (0, schedule_1.Cron)('59 * * * *'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], VideoService.prototype, "checkForUnprocessed", null);
__decorate([
    (0, schedule_1.Cron)('0 3 1 * *'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], VideoService.prototype, "cleanupOldVideoFiles", null);
__decorate([
    (0, schedule_1.Cron)('0 0 * * *'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], VideoService.prototype, "cleanupEmptyDirectories", null);
exports.VideoService = VideoService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(video_entity_1.VideoEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(video_entity_1.VideoVersionEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        storage_service_1.StorageService,
        content_service_1.ContentService])
], VideoService);
//# sourceMappingURL=video.service.js.map