import { IDDto } from '@serene-dev/la-nest-library';
import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { ViewHistoryEntity } from './view-history.entity';
import { CreateViewHistoryDTO, SaveViewLastDuration, SearchViewHistoryDTO } from './view-history.dto';
import { ViewHistoryService } from './view-history.service';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
export declare class ViewHistoryController extends BaseCRUDController<ViewHistoryEntity, SearchViewHistoryDTO> {
    protected service: ViewHistoryService;
    constructor(service: ViewHistoryService);
    search(query: SearchViewHistoryDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<ViewHistoryEntity>>;
    create(body: CreateViewHistoryDTO, auth: IAuthParam): string | Promise<ViewHistoryEntity>;
    addViewCount(param: IDDto, auth: IAuthParam): Promise<string | import("../../dtos/base.dto").GenericResponseDto>;
    saveLastDuration(param: IDDto, body: SaveViewLastDuration, auth: IAuthParam): Promise<string | import("../../dtos/base.dto").GenericResponseDto>;
}
