"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViewHistoryController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const utility_service_1 = require("../../services/utility.service");
const view_history_dto_1 = require("./view-history.dto");
const view_history_service_1 = require("./view-history.service");
let ViewHistoryController = class ViewHistoryController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async search(query, auth) {
        return super.search(query, auth);
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    async addViewCount(param, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.addViewCount(param.id, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async saveLastDuration(param, body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.saveLastDuration(param.id, body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ViewHistoryController = ViewHistoryController;
__decorate([
    (0, common_1.Get)('search'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [view_history_dto_1.SearchViewHistoryDTO, Object]),
    __metadata("design:returntype", Promise)
], ViewHistoryController.prototype, "search", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [view_history_dto_1.CreateViewHistoryDTO, Object]),
    __metadata("design:returntype", void 0)
], ViewHistoryController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id/view'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], ViewHistoryController.prototype, "addViewCount", null);
__decorate([
    (0, common_1.Patch)(':id/duration'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        view_history_dto_1.SaveViewLastDuration, Object]),
    __metadata("design:returntype", Promise)
], ViewHistoryController.prototype, "saveLastDuration", null);
exports.ViewHistoryController = ViewHistoryController = __decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiTags)(view_history_service_1.ViewHistoryService.tag),
    (0, common_1.Controller)(view_history_service_1.ViewHistoryService.path),
    __metadata("design:paramtypes", [view_history_service_1.ViewHistoryService])
], ViewHistoryController);
//# sourceMappingURL=view-history.controller.js.map