import { FindOptionsWhere, Repository } from 'typeorm';
import { ViewHistoryChunkEntity, ViewHistoryEntity } from './view-history.entity';
import { CreateViewHistoryDTO, SaveViewLastDuration, SearchViewHistoryDTO } from './view-history.dto';
import { BaseService } from '../../services/base.service';
import { IAuthParam } from '../authentication/interfaces/authentication.interface';
import { GenericResponseDto } from '../../dtos/base.dto';
import { ICreateConfig } from '@serene-dev/la-nest-library';
export declare class ViewHistoryService extends BaseService<ViewHistoryEntity, SearchViewHistoryDTO> {
    repo: Repository<ViewHistoryEntity>;
    repoChunk: Repository<ViewHistoryChunkEntity>;
    static path: string;
    constructor(repo: Repository<ViewHistoryEntity>, repoChunk: Repository<ViewHistoryChunkEntity>);
    getWhere(where: FindOptionsWhere<ViewHistoryEntity> | FindOptionsWhere<ViewHistoryEntity>[]): Promise<ViewHistoryEntity[]>;
    _create(data: CreateViewHistoryDTO, config?: ICreateConfig): Promise<ViewHistoryEntity>;
    addViewCount(historyID: string, auth: IAuthParam): Promise<GenericResponseDto>;
    saveLastDuration(historyChunkID: string, data: SaveViewLastDuration, auth: IAuthParam): Promise<GenericResponseDto>;
}
