"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViewHistoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const view_history_entity_1 = require("./view-history.entity");
const base_service_1 = require("../../services/base.service");
let ViewHistoryService = class ViewHistoryService extends base_service_1.BaseService {
    constructor(repo, repoChunk) {
        super(repo, base_enum_1.ETableName.viewHistory);
        this.repo = repo;
        this.repoChunk = repoChunk;
        this.queryStruct = [];
        this.updateControllerBlock({ update: false });
    }
    getWhere(where) {
        return this.repo.find({
            where: { ...where },
            relations: { contentSchedule: { content: true } },
        });
    }
    _create(data, config) {
        return super._create(data, config);
    }
    async addViewCount(historyID, auth) {
        await this.checkIfExistsBy({ id: historyID, creatorId: auth.id });
        await this.repoChunk.save(this.repoChunk.create({ viewHistoryId: historyID, creatorId: auth.id }));
        return { message: `Added view count` };
    }
    async saveLastDuration(historyChunkID, data, auth) {
        await this.repoChunk.update({ id: historyChunkID, creatorId: auth.id }, { durationSec: data.durationSec });
        return { message: `Saved last duration` };
    }
};
exports.ViewHistoryService = ViewHistoryService;
ViewHistoryService.path = 'view_history';
exports.ViewHistoryService = ViewHistoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(view_history_entity_1.ViewHistoryEntity)),
    __param(1, (0, typeorm_2.InjectRepository)(view_history_entity_1.ViewHistoryChunkEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository])
], ViewHistoryService);
//# sourceMappingURL=view-history.service.js.map