import { INestApplication } from '@nestjs/common';
export type PublishGraphOptions = {
    apiKey: string;
    owner: string;
    repository: string;
    branch: string;
    trigger: 'push' | 'pull';
    sha: string;
    target?: string;
    targetBranch?: string;
};
export declare class GraphPublisher {
    private readonly serializedGraph;
    constructor(app: INestApplication);
    publish(options: PublishGraphOptions): Promise<void>;
    private printGraphPublishedLog;
    private assertOption;
    private printUnauthorizedErrorLog;
    private printUnknownErrorLog;
    private printBadRequestErrorLog;
}
