"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SandboxedCodeExecutor = void 0;
const common_1 = require("@nestjs/common");
const exceptions_1 = require("@nestjs/core/errors/exceptions");
const injector_1 = require("@nestjs/core/injector");
const injector_2 = require("@nestjs/core/injector/injector");
const serialized_graph_1 = require("@nestjs/core/inspector/serialized-graph");
const metadata_scanner_1 = require("@nestjs/core/metadata-scanner");
const stream_1 = require("stream");
const vm = __importStar(require("vm"));
const PROCESS_AS_ANY = process;
let SandboxedCodeExecutor = class SandboxedCodeExecutor {
    constructor(serializedGraph, modulesContainer, metadataScanner) {
        this.serializedGraph = serializedGraph;
        this.modulesContainer = modulesContainer;
        this.metadataScanner = metadataScanner;
        this.injector = new injector_2.Injector();
    }
    execute(code, res) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const responseStream = new stream_1.PassThrough();
            this.stubStdoutAndStderrStreams(responseStream);
            responseStream.pipe(res);
            try {
                yield this.runInNewContext(`(async function() { 
      try {
        ${code}
      } catch (err) {
        console.error(err)
      }
    })();`, {
                    $: (_a = this.generatedTokensMap) !== null && _a !== void 0 ? _a : this.generateTokensMap(),
                    get: (id) => {
                        const [instanceWrapper] = this.getInstanceWrapperAndCollectionByNodeId(id);
                        if (!instanceWrapper.isDependencyTreeStatic()) {
                            throw new exceptions_1.InvalidClassScopeException(id);
                        }
                        return instanceWrapper.instance;
                    },
                    resolve: (id, contextId) => __awaiter(this, void 0, void 0, function* () {
                        const [instanceWrapper, collection] = this.getInstanceWrapperAndCollectionByNodeId(id);
                        if (instanceWrapper.isDependencyTreeStatic() &&
                            !instanceWrapper.isTransient) {
                            return instanceWrapper.instance;
                        }
                        const ctorHost = instanceWrapper.instance || {
                            constructor: instanceWrapper.metatype,
                        };
                        const instance = yield this.injector.loadPerContext(ctorHost, instanceWrapper.host, collection, contextId, instanceWrapper);
                        if (!instance) {
                            throw new exceptions_1.UnknownElementException();
                        }
                        return instance;
                    }),
                    console: Object.assign(console, {
                        table: (input) => console.log(`<DEVTOOLS_table_start>${JSON.stringify(input)}<DEVTOOLS_table_end>`),
                    }),
                    table: (input) => console.log(`<DEVTOOLS_table_start>${JSON.stringify(input)}<DEVTOOLS_table_end>`),
                    methods: (id) => {
                        const [instanceWrapper] = this.getInstanceWrapperAndCollectionByNodeId(id);
                        const proto = Object.getPrototypeOf(instanceWrapper === null || instanceWrapper === void 0 ? void 0 : instanceWrapper.instance);
                        const methods = new Set(this.metadataScanner.getAllFilteredMethodNames(proto));
                        return methods;
                    },
                    process: {
                        stdout: {
                            write: process.stdout.write.bind(process.stdout),
                        },
                        stderr: {
                            write: process.stderr.write.bind(process.stderr),
                        },
                    },
                }, { timeout: 5000 });
            }
            catch (err) {
                console.error(err);
            }
            responseStream.end('');
            this.restoreStdoutAndStderrStreams();
        });
    }
    stubStdoutAndStderrStreams(outputStream) {
        PROCESS_AS_ANY.stdout._orig_write = process.stdout.write;
        PROCESS_AS_ANY.stderr._orig_write = process.stderr.write;
        PROCESS_AS_ANY.stdout.write = (data) => {
            outputStream.write(data);
            PROCESS_AS_ANY.stdout._orig_write(data);
        };
        PROCESS_AS_ANY.stderr.write = (data) => {
            outputStream.write(data);
            PROCESS_AS_ANY.stderr._orig_write(data);
        };
    }
    generateTokensMap() {
        const nodes = JSON.parse(this.serializedGraph.toString()).nodes;
        const tokensMap = Object.values(nodes)
            .filter((node) => node.metadata.type !== 'module')
            .map((node) => {
            const key = node.label
                .toString()
                .replace(/ /g, '_')
                .replace(/\(/g, '_')
                .replace(/\:/g, '_')
                .replace(/\-/g, '_')
                .replace(/\)/g, '_');
            return [key, node.id];
        });
        this.generatedTokensMap = Object.fromEntries(tokensMap);
        return this.generatedTokensMap;
    }
    restoreStdoutAndStderrStreams() {
        PROCESS_AS_ANY.stdout.write = PROCESS_AS_ANY.stdout._orig_write;
        PROCESS_AS_ANY.stderr.write = PROCESS_AS_ANY.stderr._orig_write;
    }
    getInstanceWrapperAndCollectionByNodeId(id) {
        const node = this.serializedGraph.getNodeById(id);
        if (!node) {
            throw Error(`Node with the given ID: "${id}" does not exist.`);
        }
        if (node.metadata.type === 'module') {
            throw Error(`Module nodes can not be retrieved using the "get()" function.`);
        }
        const classNode = node;
        if (classNode.metadata.internal) {
            throw Error(`Internal nodes can not be retrieved using the "get()" function.`);
        }
        const hostRef = this.modulesContainer.getById(classNode.parent);
        const [instanceWrapper, collection] = this.getInstanceWrapperAndCollectionByType(node, hostRef);
        if (!instanceWrapper) {
            throw Error(`Node with the given ID: "${id}" does not exist.`);
        }
        return [instanceWrapper, collection];
    }
    getInstanceWrapperAndCollectionByType(node, host) {
        switch (node.metadata.type) {
            case 'controller':
                return [host.getControllerById(node.id), host.controllers];
            case 'provider':
                return [host.getProviderById(node.id), host.providers];
            case 'injectable':
                return [host.getInjectableById(node.id), host.injectables];
            case 'middleware':
                return [host.getMiddlewareById(node.id), host.middlewares];
        }
    }
    runInNewContext(code, context, opts) {
        const sandbox = {};
        const resultKey = 'SAFE_EVAL_' + Math.floor(Math.random() * 1000000);
        sandbox[resultKey] = {};
        const ctx = `
      (function() {
        Function = undefined;
        const keys = Object.getOwnPropertyNames(this).concat(['constructor']);
        keys.forEach((key) => {
          const item = this[key];
          if (!item || typeof item.constructor !== 'function') return;
          this[key].constructor = undefined;
        });
      })();
    `;
        code = ctx + resultKey + '=' + code;
        if (context) {
            Object.keys(context).forEach(function (key) {
                sandbox[key] = context[key];
            });
        }
        vm.runInNewContext(code, sandbox, opts);
        return sandbox[resultKey];
    }
};
SandboxedCodeExecutor = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [serialized_graph_1.SerializedGraph,
        injector_1.ModulesContainer,
        metadata_scanner_1.MetadataScanner])
], SandboxedCodeExecutor);
exports.SandboxedCodeExecutor = SandboxedCodeExecutor;
