import { BaseEntity } from '../entities/base.entity';
import { SearchQueryDto } from '../dtos/search.dto';
import { SDKBaseService } from '../services/base.service';
import { IItemID } from '../interfaces/index.interface';
import { BatchDeleteDto, IDDto, SetOrderDTO, ToggleActiveDTO, ToggleBulkActiveDTO } from '../dtos/base.dto';
import { IAuthParam } from '../modules/authentication/authentication.interface';
import { Chart, ChartQueryDto } from '../dtos/analytics.dto';
import { EControllerBlock } from '../enums/base.enum';
export declare class BaseController<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> {
    protected readonly service: SDKBaseService<TEntity, TSearchDto>;
    subject: string;
    idParam: string;
    static toggleBulkPath: string;
    constructor(service: SDKBaseService<TEntity, TSearchDto>);
    protected checkControllerBlock(blockType: EControllerBlock): void;
    analytics(params: ChartQueryDto): Promise<string | Chart[]>;
    getByID(params: IItemID, auth?: IAuthParam): Promise<string | TEntity>;
    search(query: TSearchDto, auth?: IAuthParam, searchFunction?: (query: any, auth: any) => Promise<import("..").ISearchResponse<TEntity>>): Promise<string | import("..").ISearchResponse<TEntity>>;
    setOrder(body: SetOrderDTO): Promise<string | boolean>;
    toggleAllActive(body: ToggleActiveDTO): Promise<string | {
        rows: number;
    }>;
    toggleBulkActive(body: ToggleBulkActiveDTO): Promise<string | {
        rows: number;
    }>;
    toggleActive(body: ToggleActiveDTO, param: IDDto): Promise<string | ToggleActiveDTO>;
}
export declare class BaseCRUController<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> extends BaseController<TEntity, TSearchDto> {
    create<TAuthParam extends IAuthParam>(body: any, auth: TAuthParam, createFunction?: (data: any) => Promise<TEntity>): string | Promise<TEntity>;
    updateByID<TUpdateDto extends Partial<TEntity>, TAuthParam extends IAuthParam>(param: IDDto, body: TUpdateDto, auth: TAuthParam, updateFunction?: (id: string, data: TUpdateDto) => Promise<TEntity>): string | Promise<TEntity>;
    update<TUpdateFunction extends (...params: any) => Promise<any>>(updateFunction: TUpdateFunction, ...params: Parameters<TUpdateFunction>): string | Promise<any>;
}
export declare class BaseCRUDController<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> extends BaseCRUController<TEntity, TSearchDto> {
    deleteByID(param: IDDto, auth: IAuthParam, deleteFunction?: (id: string, auth: IAuthParam) => Promise<any>): string | Promise<any>;
    deleteByIDs(body: BatchDeleteDto, auth: IAuthParam, deleteFunction?: (ids: string[], auth: IAuthParam) => Promise<any>): string | Promise<any>;
    restoreByID(param: IDDto, restoreFunction?: (id: string) => Promise<any>): string | Promise<any>;
    restoreByIDs(body: BatchDeleteDto, restoreFunction?: (ids: string[]) => Promise<any>): string | Promise<any>;
}
