"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileController = void 0;
const common_1 = require("@nestjs/common");
const file_service_1 = require("../services/file.service");
const file_dto_1 = require("../dtos/file.dto");
const platform_express_1 = require("@nestjs/platform-express");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../services/utility.service");
const base_dto_1 = require("../dtos/base.dto");
const path = require("path");
const authentication_guard_1 = require("../modules/authentication/authentication.guard");
const subject = `File`;
const idParam = `fileID`;
let FileController = class FileController {
    constructor(fileService) {
        this.fileService = fileService;
    }
    async upload(file, meta, auth) {
        try {
            // debugger;
            utility_service_1.UtilityClass.patchCreator(meta, auth);
            utility_service_1.UtilityClass.patchUpdater(meta, auth);
            const res = await this.fileService.upload(file, meta);
            return utility_service_1.UtilityClass.handleSuccess({
                data: res,
                message: `${subject} uploaded successfully`,
            });
        }
        catch (error) {
            // debugger
            utility_service_1.UtilityClass.handleError(error);
        }
    }
    async uploadJSON(body, auth) {
        try {
            // debugger;
            utility_service_1.UtilityClass.patchCreator(body, auth);
            utility_service_1.UtilityClass.patchUpdater(body, auth);
            const res = await this.fileService.uploadJSON(body);
            return utility_service_1.UtilityClass.handleSuccess({
                data: res,
                message: `${subject} uploaded successfully`,
            });
        }
        catch (error) {
            // debugger
            utility_service_1.UtilityClass.handleError(error);
        }
    }
    async like(params, auth) {
        params.creatorId = auth?.id;
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.fileService.likeFile(params),
            message: `${subject} like successfully`,
        });
    }
    async dislike(params, auth) {
        params.creatorId = auth?.id;
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.fileService.dislikeFile(params),
            message: `${subject} disliked successfully`,
        });
    }
    async search(query) {
        // debugger;
        return this.fileService.search(query);
    }
    async getFileByRef(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.fileService.getFileForPublic(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getFileByID(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.fileService.getFileForPublic(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async unlike(params, auth) {
        params.creatorId = auth?.id;
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.fileService.unlikeFile(params),
            message: `${subject} unliked successfully`,
        });
    }
    async deleteBatch(params) {
        // debugger;
        try {
            await this.fileService.deleteFileBatch(params);
            return utility_service_1.UtilityClass.handleSuccess({
                message: `${subject} deleted successfully`,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async delete(params) {
        await this.fileService.deleteSingleFile(params);
        return utility_service_1.UtilityClass.handleSuccess({
            message: `${subject} deleted successfully`,
        });
    }
    async restoreBatch(params) {
        // debugger;
        await this.fileService.restoreFileBatch(params);
        return utility_service_1.UtilityClass.handleSuccess({
            message: `${subject} restored successfully`,
        });
    }
    async restore(params) {
        await this.fileService.restoreFileSingle(params);
        return utility_service_1.UtilityClass.handleSuccess({
            message: `${subject} restored successfully`,
        });
    }
    async update(body, params) {
        // debugger;
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.fileService.updateFile({ ...body, ...params }),
            message: `${subject} updated successfully`,
        });
    }
    async parseFileLinkResponse(data, response) {
        if (data.buffer) {
            response.writeHead(200, [
                'Content-Type',
                data.file.fileType,
                'Content-Disposition',
                'attachment; filename=' +
                    `${data.file.title}.${data.file.fileExtension}`,
                'Access-Control-Expose-Headers',
                'Content-Disposition',
            ]);
            response.end(Buffer.from(this.fileService.base64ToArrayBuffer(data.buffer.toString())), 'binary');
        }
        else {
            response.download(path.resolve(data.path));
        }
    }
    async getFile(params, response) {
        // debugger;
        try {
            return this.parseFileLinkResponse(await this.fileService.getFilePath(params), response);
        }
        catch (error) {
            utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getFileWithToken(params, response) {
        try {
            this.parseFileLinkResponse(await this.fileService.getFilePathWithToken(params), response);
        }
        catch (error) {
            utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.FileController = FileController;
__decorate([
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, common_1.Post)('upload'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Upload a file with metadata' }),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, file_dto_1.FileUploadDto, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "upload", null);
__decorate([
    (0, common_1.Post)('upload-json'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Upload a file as JSON data' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [file_dto_1.FileUploadJSONDto, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "uploadJSON", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Put)('like'),
    (0, swagger_1.ApiOperation)({ summary: 'Like a file' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [file_dto_1.FileActionDto, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "like", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Put)('dislike'),
    (0, swagger_1.ApiOperation)({ summary: 'Dislike a file' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [file_dto_1.FileActionDto, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "dislike", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiOperation)({ summary: 'Search for files' }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [file_dto_1.FileSearchDto]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "search", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Get)('ref'),
    (0, swagger_1.ApiOperation)({ summary: 'Get file by reference' }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [file_dto_1.GetFileByRefDto]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "getFileByRef", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Get)('id/:id'),
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get file by ID' }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "getFileByID", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Put)('unlike'),
    (0, swagger_1.ApiOperation)({ summary: 'Unlike a previously liked file' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [file_dto_1.FileActionDto, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "unlike", null);
__decorate([
    (0, common_1.Delete)('delete/batch'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Delete multiple files in batch' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.BatchDeleteDto]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "deleteBatch", null);
__decorate([
    (0, common_1.Delete)(`delete/:${idParam}`),
    (0, swagger_1.ApiParam)({
        name: `${idParam}`,
        required: true,
    }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a single file' }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "delete", null);
__decorate([
    (0, common_1.Put)('restore/batch'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Restore multiple deleted files in batch' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.BatchDeleteDto]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "restoreBatch", null);
__decorate([
    (0, common_1.Put)(`restore/:${idParam}`),
    (0, swagger_1.ApiParam)({
        name: idParam,
        required: true,
    }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Restore a single deleted file' }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "restore", null);
__decorate([
    (0, common_1.Put)(`update/:${idParam}`),
    (0, swagger_1.ApiParam)({
        name: idParam,
        required: true,
    }),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Update file metadata' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [file_dto_1.FileUpdateDto, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "update", null);
__decorate([
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "parseFileLinkResponse", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)(file_service_1.FileService.downloadPathGenerator(`:${idParam}`)),
    (0, swagger_1.ApiParam)({
        name: idParam,
        required: true,
    }),
    (0, swagger_1.ApiOperation)({ summary: 'Download a file by ID' }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "getFile", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)(file_service_1.FileService.downloadPathGeneratorWithToken(':token')),
    (0, swagger_1.ApiParam)({
        name: 'token',
        required: true,
    }),
    (0, swagger_1.ApiOperation)({ summary: 'Download a file using a token' }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], FileController.prototype, "getFileWithToken", null);
exports.FileController = FileController = __decorate([
    (0, swagger_1.ApiTags)(file_service_1.FileRoutePath.tag),
    (0, common_1.Controller)(file_service_1.FileRoutePath.path),
    __metadata("design:paramtypes", [file_service_1.FileService])
], FileController);
//# sourceMappingURL=file.controller.js.map