"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaveRefDtoExtender = exports.SearchByRefQueryDto = exports.SaveRefDto = exports.ValueLabelDto = exports.SetOrderDTO = exports.ToggleBulkActiveDTO = exports.ToggleActiveDTO = exports.IDDto = exports.BatchDeleteDto = exports.BaseDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const utility_service_1 = require("../services/utility.service");
const class_transformer_1 = require("class-transformer");
class BaseDto {
    constructor(obj) {
        if (obj)
            Object.assign(this, obj);
    }
}
exports.BaseDto = BaseDto;
class BatchDeleteDto {
}
exports.BatchDeleteDto = BatchDeleteDto;
__decorate([
    (0, class_validator_1.IsArray)({}),
    (0, swagger_1.ApiProperty)({
        default: new Array(5).fill(1).map(() => utility_service_1.UtilityClass.generateUUID),
    }),
    __metadata("design:type", Array)
], BatchDeleteDto.prototype, "ids", void 0);
class IDDto {
}
exports.IDDto = IDDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], IDDto.prototype, "id", void 0);
class ToggleActiveDTO {
}
exports.ToggleActiveDTO = ToggleActiveDTO;
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, swagger_1.ApiProperty)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], ToggleActiveDTO.prototype, "active", void 0);
class ToggleBulkActiveDTO extends ToggleActiveDTO {
}
exports.ToggleBulkActiveDTO = ToggleBulkActiveDTO;
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.ArrayMinSize)(1),
    (0, swagger_1.ApiProperty)({}),
    __metadata("design:type", Array)
], ToggleBulkActiveDTO.prototype, "ids", void 0);
class SetOrderItem {
}
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SetOrderItem.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], SetOrderItem.prototype, "order", void 0);
class SetOrderDTO {
}
exports.SetOrderDTO = SetOrderDTO;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [SetOrderItem] }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => SetOrderItem),
    __metadata("design:type", Array)
], SetOrderDTO.prototype, "items", void 0);
class ValueLabelDto {
}
exports.ValueLabelDto = ValueLabelDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string' }),
    __metadata("design:type", Object)
], ValueLabelDto.prototype, "value", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], ValueLabelDto.prototype, "label", void 0);
class SaveRefDto {
}
exports.SaveRefDto = SaveRefDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SaveRefDto.prototype, "refCat", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SaveRefDto.prototype, "refNo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SaveRefDto.prototype, "slug", void 0);
class SearchByRefQueryDto extends (0, swagger_1.PartialType)(SaveRefDto) {
}
exports.SearchByRefQueryDto = SearchByRefQueryDto;
class SaveRefDtoExtender {
}
exports.SaveRefDtoExtender = SaveRefDtoExtender;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: SaveRefDto }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => SaveRefDto),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", SaveRefDto)
], SaveRefDtoExtender.prototype, "ref", void 0);
//# sourceMappingURL=base.dto.js.map