import { BaseDto } from './base.dto';
import { SearchQueryDto } from './search.dto';
import { FileEntity } from '../entities/file.entity';
export declare class GetFileByRefDto {
    refCat: string;
    refNo: string;
}
declare const FileUpdateDto_base: import("@nestjs/common").Type<GetFileByRefDto & BaseDto<unknown>>;
export declare class FileUpdateDto extends FileUpdateDto_base {
    description?: string;
    title: string;
}
export declare class FileUploadDto extends FileUpdateDto {
    file: File;
}
export declare class FileUploadJSONMiniDto {
    dataURI: string;
    fileExtension: string;
}
declare const FileUploadJSONDto_base: import("@nestjs/common").Type<FileUpdateDto & FileUploadJSONMiniDto>;
export declare class FileUploadJSONDto extends FileUploadJSONDto_base {
}
export declare class FileActionDto extends BaseDto {
    fileID: string;
}
declare const FileSearchDto_base: import("@nestjs/common").Type<Partial<GetFileByRefDto> & SearchQueryDto<unknown>>;
export declare class FileSearchDto extends FileSearchDto_base {
    description: string;
    title: string;
}
declare const _FileToken_base: import("@nestjs/common").Type<Pick<FileEntity, "id" | "path" | "title" | "fileType" | "fileExtension" | "contentId">>;
declare class _FileToken extends _FileToken_base {
    fileID?: string;
}
export declare class FileToken implements _FileToken {
    title: string;
    fileExtension: string;
    fileType?: string;
    contentId?: string;
    path?: string;
    id?: string;
    fileID?: string;
}
export {};
