import { BaseDto } from './base.dto';
import { ESortOrder } from '../enums/search.enum';
export declare class SearchQueryDto<T = any> extends BaseDto {
    active?: boolean;
    createdAt?: string;
    updatedAt?: string;
    creatorId?: string;
    updaterId?: string;
    createdFrom?: string;
    createdTo?: string;
    updatedFrom?: string;
    updatedTo?: string;
    orgID?: string;
    pageNumber?: number;
    pageSize?: number;
    sortField?: keyof T;
    sortDirection?: ESortOrder;
    query?: string;
}
export declare class SearchResponseDto<TResultRow = any> {
    pageNumber?: number;
    pageSize?: number;
    sortField?: string;
    sortDirection?: ESortOrder;
    data: TResultRow[];
    dataLength: number;
    total: number;
}
