"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefEntity = exports.BaseEntity = void 0;
const typeorm_1 = require("typeorm");
const authentication_entity_1 = require("../modules/authentication/authentication.entity");
const utility_service_1 = require("../services/utility.service");
class BaseEntity {
    constructor(obj) {
        if (obj)
            Object.assign(this, obj);
    }
}
exports.BaseEntity = BaseEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], BaseEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'json' }),
    __metadata("design:type", Object)
], BaseEntity.prototype, "meta", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp' }),
    (0, typeorm_1.CreateDateColumn)({ ...utility_service_1.UtilityClass.columnTimestamp }),
    __metadata("design:type", String)
], BaseEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], BaseEntity.prototype, "active", void 0);
__decorate([
    (0, typeorm_1.DeleteDateColumn)({ ...utility_service_1.UtilityClass.columnTimestamp }),
    __metadata("design:type", Date)
], BaseEntity.prototype, "deletedAt", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp' }),
    (0, typeorm_1.UpdateDateColumn)({ ...utility_service_1.UtilityClass.columnTimestamp }),
    __metadata("design:type", String)
], BaseEntity.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], BaseEntity.prototype, "creatorId", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], BaseEntity.prototype, "updaterId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => authentication_entity_1.AuthEntity),
    __metadata("design:type", Object)
], BaseEntity.prototype, "creator", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => authentication_entity_1.AuthEntity),
    __metadata("design:type", Object)
], BaseEntity.prototype, "updater", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'uuid' }),
    __metadata("design:type", String)
], BaseEntity.prototype, "orgID", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Number)
], BaseEntity.prototype, "order", void 0);
class RefEntity {
}
exports.RefEntity = RefEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], RefEntity.prototype, "refCat", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], RefEntity.prototype, "refNo", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 255, nullable: true }),
    __metadata("design:type", String)
], RefEntity.prototype, "slug", void 0);
//# sourceMappingURL=base.entity.js.map