import { SearchQueryDto } from '../dtos/search.dto';
import { ESearchCondition, ESearchJoinCondition } from '../enums/search.enum';
export interface ISearchQueryItem<T> {
    tableAlias?: string;
    value?: string;
    field: keyof T;
    actualField?: keyof T;
    type?: 'boolean';
    subFields?: string[];
    upperRange?: keyof T;
    lowerRange?: keyof T;
    /**@default ESearchCondition.equal */
    condition?: ESearchCondition;
    /**@default ESearchJoinCondition.and */
    joinCondition?: ESearchJoinCondition;
}
export interface ISearchResponse<TResultRow = any> extends SearchQueryDto {
    data: TResultRow[];
    total: number;
}
