import { AuthenticationService } from './authentication.service';
import { ChangePasswordDTO, LoginDTO, LogoutDTO, RegisterDTO, RequestPasswordResetDTO, ResetPasswordDTO, SystemLogoutDTO, ToggleAuthDTO, VerifyResetPasswordTokenDTO } from './authentication.dto';
import { IDDto } from '../../dtos/base.dto';
import { IAuthParam } from './authentication.interface';
export declare class AuthenticationController {
    protected readonly service: AuthenticationService;
    constructor(service: AuthenticationService);
    logout(body: LogoutDTO): Promise<string | boolean>;
    systemLogout(body: SystemLogoutDTO): Promise<string | boolean>;
    login(body: LoginDTO): Promise<string | import("./authentication.entity").AuthEntity>;
    register(body: RegisterDTO): Promise<string | import("./authentication.entity").AuthEntity>;
    requestPasswordReset(body: RequestPasswordResetDTO): Promise<string | {
        message: string;
    }>;
    verifyResetPasswordToken(body: VerifyResetPasswordTokenDTO): Promise<string | import("./authentication.service").IPasswordResetTokenObj>;
    resetPassword(body: ResetPasswordDTO): Promise<string | {
        message: string;
    }>;
    toggle(body: ToggleAuthDTO, param: IDDto): Promise<string | import("./authentication.entity").AuthEntity>;
    passwordChange(body: ChangePasswordDTO, auth: IAuthParam): Promise<string | {
        success: boolean;
    }>;
}
