import { AuthEntity } from './authentication.entity';
import { ETokenDropType } from './authentication.enum';
import { TokenSessionEntity } from '../../entities/token-session.entity';
declare class AuthBaseDTO implements Partial<AuthEntity> {
    /**It shouldn't be set by the user */
    type?: string;
    orgID?: string;
    email?: string;
}
export declare class RegisterDTO extends AuthBaseDTO implements Partial<AuthEntity> {
    password?: string;
    login: boolean;
    firstname: string;
    lastname: string;
}
export declare class RequestPasswordResetDTO extends AuthBaseDTO implements Partial<AuthEntity> {
    resetURL: string;
}
export declare class VerifyResetPasswordTokenDTO {
    token: string;
}
export declare class VerifyResetPasswordTokenResponseDTO {
    email: string;
}
export declare class ResetPasswordDTO extends VerifyResetPasswordTokenDTO {
    password: string;
}
declare const ChangePasswordDTO_base: import("@nestjs/common").Type<Pick<ResetPasswordDTO, "password">>;
export declare class ChangePasswordDTO extends ChangePasswordDTO_base {
    oldPassword: string;
}
export declare class LoginDTO extends AuthBaseDTO implements Partial<AuthEntity> {
    password?: string;
}
export declare class LogoutDTO implements Partial<TokenSessionEntity> {
    token: string;
    dropReason?: ETokenDropType;
    forcedDrop?: boolean;
}
export declare class ToggleAuthDTO {
    active: boolean;
}
export declare class SystemLogoutDTO implements Partial<TokenSessionEntity> {
    ownerID: string;
    dropReason: ETokenDropType;
}
export {};
