"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemLogoutDTO = exports.ToggleAuthDTO = exports.LogoutDTO = exports.LoginDTO = exports.ChangePasswordDTO = exports.ResetPasswordDTO = exports.VerifyResetPasswordTokenResponseDTO = exports.VerifyResetPasswordTokenDTO = exports.RequestPasswordResetDTO = exports.RegisterDTO = void 0;
const class_validator_1 = require("class-validator");
const authentication_enum_1 = require("./authentication.enum");
const swagger_1 = require("@nestjs/swagger");
const base_sample_1 = require("../../samples/base.sample");
const utility_service_1 = require("../../services/utility.service");
class AuthBaseDTO {
}
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: 'string', default: base_sample_1.Sample.orgID, required: false }),
    __metadata("design:type", String)
], AuthBaseDTO.prototype, "orgID", void 0);
__decorate([
    (0, class_validator_1.IsEmail)(),
    (0, swagger_1.ApiProperty)({ type: 'string', default: base_sample_1.Sample.email, required: true }),
    __metadata("design:type", String)
], AuthBaseDTO.prototype, "email", void 0);
class RegisterDTO extends AuthBaseDTO {
}
exports.RegisterDTO = RegisterDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'string', default: base_sample_1.Sample.password, required: false }),
    __metadata("design:type", String)
], RegisterDTO.prototype, "password", void 0);
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], RegisterDTO.prototype, "login", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', default: utility_service_1.UtilityClass.generateUserName }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], RegisterDTO.prototype, "firstname", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', default: utility_service_1.UtilityClass.generateUserName }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], RegisterDTO.prototype, "lastname", void 0);
class RequestPasswordResetDTO extends AuthBaseDTO {
}
exports.RequestPasswordResetDTO = RequestPasswordResetDTO;
__decorate([
    (0, class_validator_1.IsUrl)({ require_tld: false }),
    (0, swagger_1.ApiProperty)({ example: 'http://localhost' }),
    __metadata("design:type", String)
], RequestPasswordResetDTO.prototype, "resetURL", void 0);
class VerifyResetPasswordTokenDTO {
}
exports.VerifyResetPasswordTokenDTO = VerifyResetPasswordTokenDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], VerifyResetPasswordTokenDTO.prototype, "token", void 0);
class VerifyResetPasswordTokenResponseDTO {
}
exports.VerifyResetPasswordTokenResponseDTO = VerifyResetPasswordTokenResponseDTO;
__decorate([
    (0, class_validator_1.IsEmail)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], VerifyResetPasswordTokenResponseDTO.prototype, "email", void 0);
class ResetPasswordDTO extends VerifyResetPasswordTokenDTO {
}
exports.ResetPasswordDTO = ResetPasswordDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'string', default: base_sample_1.Sample.password, required: true }),
    __metadata("design:type", String)
], ResetPasswordDTO.prototype, "password", void 0);
class ChangePasswordDTO extends (0, swagger_1.IntersectionType)((0, swagger_1.PickType)(ResetPasswordDTO, ['password'])) {
}
exports.ChangePasswordDTO = ChangePasswordDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ChangePasswordDTO.prototype, "oldPassword", void 0);
class LoginDTO extends AuthBaseDTO {
}
exports.LoginDTO = LoginDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'string', default: base_sample_1.Sample.password, required: true }),
    __metadata("design:type", String)
], LoginDTO.prototype, "password", void 0);
class LogoutDTO {
}
exports.LogoutDTO = LogoutDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'string', required: true }),
    __metadata("design:type", String)
], LogoutDTO.prototype, "token", void 0);
class ToggleAuthDTO {
}
exports.ToggleAuthDTO = ToggleAuthDTO;
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, swagger_1.ApiProperty)({ type: 'boolean', required: true }),
    __metadata("design:type", Boolean)
], ToggleAuthDTO.prototype, "active", void 0);
class SystemLogoutDTO {
}
exports.SystemLogoutDTO = SystemLogoutDTO;
__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, swagger_1.ApiProperty)({ type: 'string', required: true }),
    __metadata("design:type", String)
], SystemLogoutDTO.prototype, "ownerID", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(authentication_enum_1.ETokenDropType),
    (0, swagger_1.ApiProperty)({
        enum: authentication_enum_1.ETokenDropType,
        default: authentication_enum_1.ETokenDropType.reset,
        required: true,
    }),
    __metadata("design:type", String)
], SystemLogoutDTO.prototype, "dropReason", void 0);
//# sourceMappingURL=authentication.dto.js.map