import { CanActivate, ExecutionContext } from '@nestjs/common';
import { TokenService } from '../../services/token.service';
import { AuthenticationService } from './authentication.service';
import { Reflector } from '@nestjs/core';
import { evt } from '../../services/environment.service';
import { IAuthParam } from './authentication.interface';
import { AuthEntity } from './authentication.entity';
export declare class AuthenticationGuard<TEntity extends AuthEntity = AuthEntity> implements CanActivate {
    protected tokenService: TokenService;
    protected authS: AuthenticationService<TEntity>;
    protected reflector: Reflector;
    skipEnvironment: typeof evt.ENVIRONMENT;
    constructor(tokenService: TokenService, authS: AuthenticationService<TEntity>, reflector: Reflector);
    extraCheck?: (context: ExecutionContext, payload: IAuthParam, isPublic: boolean) => Promise<boolean>;
    verifyAuthToken(context: ExecutionContext, payload: IAuthParam): Promise<void>;
    canActivate(context: ExecutionContext): Promise<boolean>;
    private extractTokenFromHeader;
    requestPatcher: (request: any, payload: any) => Promise<void>;
    static provideGuard(): {
        provide: string;
        useClass: typeof AuthenticationGuard;
    };
}
export declare const PublicAuth: () => import("@nestjs/common").CustomDecorator<string>;
export declare const AuthParam: (...dataOrPipes: any[]) => ParameterDecorator;
