"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var AuthenticationGuard_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthParam = exports.PublicAuth = exports.AuthenticationGuard = void 0;
const common_1 = require("@nestjs/common");
const token_service_1 = require("../../services/token.service");
const authentication_service_1 = require("./authentication.service");
const authentication_enum_1 = require("./authentication.enum");
const common_2 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const environment_service_1 = require("../../services/environment.service");
let AuthenticationGuard = AuthenticationGuard_1 = class AuthenticationGuard {
    constructor(tokenService, authS, reflector) {
        this.tokenService = tokenService;
        this.authS = authS;
        this.reflector = reflector;
        this.skipEnvironment = 'dev';
        this.requestPatcher = async (request, payload) => {
            request['user'] = payload || null;
        };
    }
    verifyAuthToken(context, payload) {
        return this.authS.verifyAuthToken(payload.token);
    }
    async canActivate(context) {
        const isPublic = this.reflector.getAllAndOverride(IS_PUBLIC_KEY, [
            context.getHandler(),
            context.getClass(),
        ]);
        // debugger;
        const request = context.switchToHttp().getRequest();
        const token = this.extractTokenFromHeader(request);
        const skip = environment_service_1.evt.ENVIRONMENT == this.skipEnvironment;
        // const skip = true;
        // const d = evt.ENVIRONMENT;
        if (!token && !skip) {
            if (isPublic)
                return true;
            throw new common_1.UnauthorizedException();
        }
        let payload;
        try {
            if (token) {
                payload = await this.tokenService.decryptToken(token, {
                    ignoreExpiration: skip,
                });
                payload.token = token;
                await this.verifyAuthToken(context, payload);
                await this.requestPatcher(request, payload);
            }
        }
        catch (error) {
            this.authS.forceLogoutSingle({
                token,
                dropReason: authentication_enum_1.ETokenDropType.expiration,
            });
            if (isPublic)
                return true;
            throw new common_1.UnauthorizedException('Token Expired');
        }
        return this.extraCheck
            ? await this.extraCheck(context, payload, isPublic)
            : true;
    }
    extractTokenFromHeader(request) {
        const [type, token] = request.headers.authorization?.split(' ') ?? [];
        return type === 'Bearer' ? token : undefined;
    }
    static provideGuard() {
        return {
            provide: core_1.APP_GUARD,
            useClass: AuthenticationGuard_1,
        };
    }
};
exports.AuthenticationGuard = AuthenticationGuard;
exports.AuthenticationGuard = AuthenticationGuard = AuthenticationGuard_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [token_service_1.TokenService,
        authentication_service_1.AuthenticationService,
        core_1.Reflector])
], AuthenticationGuard);
const IS_PUBLIC_KEY = 'isPublic';
const PublicAuth = () => (0, common_2.SetMetadata)(IS_PUBLIC_KEY, true);
exports.PublicAuth = PublicAuth;
exports.AuthParam = (0, common_1.createParamDecorator)((data, req) => req.getArgByIndex(0).user);
//# sourceMappingURL=authentication.guard.js.map