"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticationModule = void 0;
const common_1 = require("@nestjs/common");
const authentication_service_1 = require("./authentication.service");
const authentication_controller_1 = require("./authentication.controller");
const authentication_entity_1 = require("./authentication.entity");
const typeorm_1 = require("@nestjs/typeorm");
const token_service_1 = require("../../services/token.service");
const jwt_1 = require("@nestjs/jwt");
const authentication_guard_1 = require("./authentication.guard");
const base_module_1 = require("../base.module");
const authentication_session_entity_1 = require("./authentication-session.entity");
const token_session_entity_1 = require("../../entities/token-session.entity");
const providers = [
    jwt_1.JwtService,
    token_service_1.TokenService,
    authentication_service_1.AuthenticationService,
    authentication_service_1.AuthSessionService,
    authentication_guard_1.AuthenticationGuard,
    token_service_1.TokenSessionService,
];
const controllers = [authentication_controller_1.AuthenticationController];
let AuthenticationModule = class AuthenticationModule extends base_module_1.BaseModule {
};
exports.AuthenticationModule = AuthenticationModule;
AuthenticationModule.entities = [
    authentication_entity_1.AuthEntity,
    authentication_session_entity_1.AuthSessionEntity,
    token_session_entity_1.TokenSessionEntity,
];
AuthenticationModule.services = providers;
exports.AuthenticationModule = AuthenticationModule = __decorate([
    (0, common_1.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature(AuthenticationModule.entities)],
        providers,
        controllers,
        exports: [...providers],
    })
], AuthenticationModule);
//# sourceMappingURL=authentication.module.js.map