import { BaseService } from '../../services/base.service';
import { AuthEntity } from './authentication.entity';
import { ChangePasswordDTO, LoginDTO, LogoutDTO, RegisterDTO, RequestPasswordResetDTO, ResetPasswordDTO, SystemLogoutDTO, ToggleAuthDTO } from './authentication.dto';
import { FindOptionsWhere, Repository } from 'typeorm';
import { TokenService, TokenSessionService } from '../../services/token.service';
import { ETokenDropType } from './authentication.enum';
import { AuthSessionEntity } from './authentication-session.entity';
import { IAuthParam } from './authentication.interface';
import { ICreateConfig } from '../../interfaces/index.interface';
export declare class AuthSessionService extends BaseService<AuthSessionEntity> {
    readonly repo: Repository<AuthSessionEntity>;
    constructor(repo: Repository<AuthSessionEntity>);
    exists(where: FindOptionsWhere<AuthSessionEntity>[] | FindOptionsWhere<AuthSessionEntity>): Promise<boolean>;
}
export declare class AuthenticationService<TEntity extends AuthEntity = AuthEntity> extends BaseService<TEntity> {
    repo: Repository<AuthEntity>;
    tokenService: TokenService;
    authenticationSessionService: AuthSessionService;
    tokenSessionService: TokenSessionService;
    static path: string;
    readonly saltOrRounds = 10;
    mailSenderName: string;
    tokenExpiry: string | number;
    constructor(repo: Repository<AuthEntity>, tokenService: TokenService, authenticationSessionService: AuthSessionService, tokenSessionService: TokenSessionService);
    decryptToken(token: string, ignoreExpiration?: boolean): Promise<{
        id: string;
    }>;
    generateToken(auth: AuthEntity): Promise<{
        token: string;
    }>;
    passwordComparison(body: LoginDTO, config?: ICreateConfig): Promise<AuthEntity>;
    getUserOrganisationsFunc: (query: Omit<LoginDTO, 'password'>) => Promise<any[]>;
    getUserOrganisationsByLogin: ({ password, ...body }: LoginDTO) => Promise<any[]>;
    login(body: LoginDTO, config?: ICreateConfig): Promise<AuthEntity>;
    forceLogout(body: SystemLogoutDTO): Promise<boolean>;
    forceLogoutSingle(body: {
        token: string;
        dropReason: ETokenDropType;
    }): Promise<boolean>;
    logout(body: LogoutDTO): Promise<boolean>;
    accountCreationMailCreator: (auth: AuthEntity, config?: {
        showPasswordInMail?: boolean;
    }) => Promise<string>;
    register(body: RegisterDTO, config?: ICreateConfig): Promise<AuthEntity>;
    passwordResetTokenIO(payload: AuthEntity): Promise<string>;
    passwordResetTokenIO(payload: undefined, token: string): Promise<IPasswordResetTokenObj>;
    requestPasswordReset(body: RequestPasswordResetDTO): Promise<{
        message: string;
    }>;
    verifyResetPasswordToken(body: {
        token: string;
    }): Promise<IPasswordResetTokenObj>;
    verifyAuthToken(token: string): Promise<void>;
    _resetPasswordFunction(body: {
        authID: string;
        email: string;
        password: string;
    }): Promise<{
        message: string;
    }>;
    resetPassword(body: ResetPasswordDTO): Promise<{
        message: string;
    }>;
    changePassword(body: ChangePasswordDTO, auth: IAuthParam): Promise<{
        success: boolean;
    }>;
    toggleStatus(id: string, data: ToggleAuthDTO): Promise<TEntity>;
}
export interface IPasswordResetTokenObj {
    authID: string;
    email: string;
}
