"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticationService = exports.AuthSessionService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../../services/base.service");
const authentication_entity_1 = require("./authentication.entity");
const base_enum_1 = require("../../enums/base.enum");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const utility_service_1 = require("../../services/utility.service");
const bcrypt = require("bcrypt");
const token_service_1 = require("../../services/token.service");
const authentication_enum_1 = require("./authentication.enum");
const authentication_session_entity_1 = require("./authentication-session.entity");
const mail_service_1 = require("../../services/mail.service");
let AuthSessionService = class AuthSessionService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.authSession);
        this.repo = repo;
    }
    exists(where) {
        return this.repo.exist({ where });
    }
};
exports.AuthSessionService = AuthSessionService;
exports.AuthSessionService = AuthSessionService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(authentication_session_entity_1.AuthSessionEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], AuthSessionService);
let AuthenticationService = class AuthenticationService extends base_service_1.BaseService {
    constructor(repo, tokenService, authenticationSessionService, tokenSessionService) {
        super(repo, base_enum_1.ETableName.authentication);
        this.repo = repo;
        this.tokenService = tokenService;
        this.authenticationSessionService = authenticationSessionService;
        this.tokenSessionService = tokenSessionService;
        this.saltOrRounds = 10;
        this.mailSenderName = 'Account Manager';
        this.tokenExpiry = '7d';
        this.getUserOrganisationsByLogin = async ({ password, ...body }) => {
            if (!this.getUserOrganisationsFunc)
                utility_service_1.UtilityClass.throwError({
                    message: `getUserOrganisationsFunction is missing`,
                    statusCode: 500,
                });
            const foundQuery = {
                where: {
                    email: body.email,
                    type: body.type,
                },
                select: { password: true, id: true },
            };
            const founds = await this.repo.find(foundQuery);
            if (!founds)
                return [];
            const correct = (await Promise.all(founds.map((found) => bcrypt.compare(password, found.password)))).some((x) => !!x);
            if (!correct)
                throw utility_service_1.UtilityClass.throwError({
                    message: `Wrong authentication details. Please check the details`,
                });
            else
                return this.getUserOrganisationsFunc(body);
        };
        this.accountCreationMailCreator = async (auth, config) => utility_service_1.UtilityClass.emailTemplater('New Account Creation', `Dear ${auth.firstname},\nYour new account has been provisioned\n${config?.showPasswordInMail ? `password: ${auth.password}` : ''}`);
    }
    decryptToken(token, ignoreExpiration = false) {
        return this.tokenService.decryptToken(token, {
            ignoreExpiration,
        });
    }
    generateToken(auth) {
        return this.tokenService.generateToken({ id: auth.id }, { expiresIn: this.tokenExpiry });
    }
    async passwordComparison(body, config) {
        const foundQuery = {
            where: {
                orgID: body.orgID,
                email: body.email,
                type: body.type,
            },
            select: { password: true, id: true },
        };
        const duplicates = await (config?.entityManager
            ? config.entityManager.count(authentication_entity_1.AuthEntity, foundQuery)
            : this.repo.count(foundQuery));
        if (duplicates > 1) {
            console.log('Please select your organisation', foundQuery);
            utility_service_1.UtilityClass.throwError({
                message: `Please select your organisation`,
                statusCode: 400,
                error: { foundQuery },
            });
        }
        const found = await (config?.entityManager
            ? config.entityManager.findOne(authentication_entity_1.AuthEntity, foundQuery)
            : this.repo.findOne(foundQuery));
        if (!found)
            utility_service_1.UtilityClass.throwError({ message: `User doesn't exist` });
        const correct = await bcrypt.compare(body.password, found.password);
        if (!correct)
            throw utility_service_1.UtilityClass.throwError({
                message: `Wrong authentication details. Please check the details`,
            });
        return found;
    }
    async login(body, config) {
        await this.passwordComparison(body, config);
        const foundQuery = {
            where: {
                orgID: body.orgID,
                email: body.email,
                type: body.type,
            },
        };
        const found = await (config?.entityManager
            ? config.entityManager.findOne(authentication_entity_1.AuthEntity, foundQuery)
            : this.repo.findOne(foundQuery));
        found.token = (await this.generateToken(found)).token;
        delete found.password;
        this.authenticationSessionService._create({
            token: found.token,
            ownerID: found.id,
        }, config);
        found.token = `Bearer ${found.token}`;
        return found;
    }
    async forceLogout(body) {
        const found = await this.authenticationSessionService.find({
            ownerID: body.ownerID,
            active: true,
        });
        if (!found?.length)
            return true;
        await Promise.all(found.map((ses) => {
            this.authenticationSessionService._updateByID(ses.id, {
                ...body,
                forcedDrop: true,
                active: false,
                droppedDate: new Date().toISOString(),
            });
        }));
        return true;
    }
    async forceLogoutSingle(body) {
        return this.logout({
            ...body,
            forcedDrop: true,
            dropReason: body.dropReason,
        });
    }
    async logout(body) {
        const found = await this.authenticationSessionService.findOne({
            token: body.token,
        });
        if (!found)
            return true;
        delete body.token;
        this.authenticationSessionService._updateByID(found.id, {
            active: false,
            forcedDrop: body.forcedDrop || false,
            dropReason: body.dropReason || authentication_enum_1.ETokenDropType.user,
            droppedDate: new Date().toISOString(),
        });
        return true;
    }
    async register(body, config) {
        const auth = Object.assign(new authentication_entity_1.AuthEntity(), body);
        const manager = config?.entityManager;
        const foundQuery = {
            orgID: auth.orgID,
            email: auth.email,
            type: auth.type,
        };
        const found = await (manager
            ? manager.findOne(authentication_entity_1.AuthEntity, { where: foundQuery })
            : this.repo.findOne({ where: foundQuery }));
        if (found)
            utility_service_1.UtilityClass.throwError({ message: `User already exists` });
        const showPasswordInMail = !auth.password;
        if (!auth.password) {
            auth.password = utility_service_1.UtilityClass.generateUUID.split('-')[0];
        }
        mail_service_1.MailService.sendMail({
            to: auth.email,
            html: await this.accountCreationMailCreator(auth, { showPasswordInMail }),
            from: `system${mail_service_1.MailService.baseEmailSuffix}`,
            subject: `New Account Creation`,
            _senderName: this.mailSenderName,
        });
        const password = await bcrypt.hash(auth.password, this.saltOrRounds);
        const saveObj = { ...auth, password };
        const res = await (manager
            ? manager.save(authentication_entity_1.AuthEntity, saveObj)
            : this.repo.save(saveObj));
        if (body.login)
            return this.login({ ...body, password: body.password || auth.password }, config);
        delete res.password;
        return res;
    }
    async passwordResetTokenIO(authPayload, token) {
        if (authPayload)
            return (await this.tokenService.generateToken({
                authID: authPayload.id,
                email: authPayload.email,
            })).token;
        else
            return await this.tokenService.decryptToken(token);
    }
    async requestPasswordReset(body) {
        const auth = await this.repo.findOne({
            where: { email: body.email, type: body.type, orgID: body.orgID },
        });
        if (!auth)
            utility_service_1.UtilityClass.throwError({ message: `User does not exist` });
        // debugger;
        const entity = await this.tokenSessionService._create({
            ownerID: auth.id,
            token: await this.passwordResetTokenIO(auth),
        });
        const resetLink = `${body.resetURL}?token=${entity.token}`;
        mail_service_1.MailService.sendMail({
            to: auth.email,
            html: await utility_service_1.UtilityClass.emailTemplater(`Password Reset`, `A password reset was initiated for your account <strong>${auth.email}</strong><br>Please use this link <a href="${resetLink}">${resetLink}</a> to reset your password.<br>If this request was not initiated by you, please ignore it.`),
            _senderName: this.mailSenderName,
            subject: `Password Reset`,
        });
        return { message: `Sent reset link` };
    }
    async verifyResetPasswordToken(body) {
        const foundToken = await this.tokenSessionService.findOne({
            token: body.token,
        });
        if (!foundToken)
            utility_service_1.UtilityClass.throwError({ message: `Token does not exist` });
        const tokenContent = await this.passwordResetTokenIO(undefined, body.token);
        return tokenContent;
    }
    async verifyAuthToken(token) {
        if (!(await this.authenticationSessionService.exists({
            token,
            active: true,
        })))
            throw 'Token not found';
    }
    async _resetPasswordFunction(body) {
        const password = await bcrypt.hash(body.password, this.saltOrRounds);
        await this.repo.update({ id: body.authID }, { password });
        mail_service_1.MailService.sendMail({
            to: body.email,
            html: await utility_service_1.UtilityClass.emailTemplater(`Password Reset Success`, `Your account's password has been reset successfully`),
            _senderName: this.mailSenderName,
            subject: `Password Reset Success`,
        });
        return { message: `Password reset successfully` };
    }
    async resetPassword(body) {
        const tokenResponse = await this.verifyResetPasswordToken(body);
        const res = await this._resetPasswordFunction({
            authID: tokenResponse.authID,
            email: tokenResponse.email,
            password: body.password,
        });
        this.tokenSessionService.drop({ token: body.token });
        return res;
    }
    async changePassword(body, auth) {
        const _auth = await this.repo.findOne({ where: { id: auth.id } });
        await this.passwordComparison({
            email: _auth.email,
            orgID: _auth.orgID,
            password: body.oldPassword,
            type: _auth.type,
        });
        const password = await bcrypt.hash(body.password, this.saltOrRounds);
        await this.repo.update({ id: auth.id }, { password });
        return { success: true };
    }
    async toggleStatus(id, data) {
        await this.checkIfExistsById(id);
        await this.toggleActive(id, data);
        await this.forceLogout({
            ownerID: id,
            dropReason: authentication_enum_1.ETokenDropType.inactive,
        });
        return this.getById(id);
    }
};
exports.AuthenticationService = AuthenticationService;
AuthenticationService.path = 'authentication';
exports.AuthenticationService = AuthenticationService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(authentication_entity_1.AuthEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        token_service_1.TokenService,
        AuthSessionService,
        token_service_1.TokenSessionService])
], AuthenticationService);
//# sourceMappingURL=authentication.service.js.map