import { CategoryService } from './category.service';
import { CreateCategoryDto, GetCategoryBySlugDto, GetCategoryBySlugQueryDto, SearchCategoryDto, UpdateCategoryDto } from './category.dto';
import { CategoryEntity } from './category.entity';
import { BaseCRUDController } from '../../controllers/base.controller';
import { IDDto } from '../../dtos/base.dto';
import { RoutePath } from '../../classes/route-path.class';
export declare const CategoryRoutePath: RoutePath;
export declare class CategoryController extends BaseCRUDController<CategoryEntity, SearchCategoryDto> {
    protected readonly service: CategoryService;
    constructor(service: CategoryService);
    create(createCategoryDto: CreateCategoryDto, auth: any): string | Promise<CategoryEntity>;
    search(query: SearchCategoryDto): Promise<string | import("../..").ISearchResponse<CategoryEntity>>;
    getBySlug(query: GetCategoryBySlugQueryDto): string | Promise<GetCategoryBySlugDto[]>;
    updateByID(param: IDDto, updateCategoryDto: UpdateCategoryDto, auth: any): string | Promise<CategoryEntity>;
}
