"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryController = exports.CategoryRoutePath = void 0;
const common_1 = require("@nestjs/common");
const category_service_1 = require("./category.service");
const category_dto_1 = require("./category.dto");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("../../controllers/base.controller");
const authentication_guard_1 = require("../authentication/authentication.guard");
const base_dto_1 = require("../../dtos/base.dto");
const utility_service_1 = require("../../services/utility.service");
const search_dto_1 = require("../../dtos/search.dto");
const route_path_class_1 = require("../../classes/route-path.class");
exports.CategoryRoutePath = new route_path_class_1.RoutePath('category');
let CategoryController = class CategoryController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    create(createCategoryDto, auth) {
        return super.create(createCategoryDto, auth);
    }
    search(query) {
        return super.search(query);
    }
    getBySlug(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.service.getBySlug(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    updateByID(param, updateCategoryDto, auth) {
        return super.updateByID(param, updateCategoryDto, auth);
    }
};
exports.CategoryController = CategoryController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new category' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [category_dto_1.CreateCategoryDto, Object]),
    __metadata("design:returntype", void 0)
], CategoryController.prototype, "create", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiOperation)({ summary: 'Search categories' }),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [category_dto_1.SearchCategoryDto]),
    __metadata("design:returntype", void 0)
], CategoryController.prototype, "search", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('slug'),
    (0, swagger_1.ApiOperation)({ summary: 'Get category by slug' }),
    (0, swagger_1.ApiResponse)({ type: [category_dto_1.GetCategoryBySlugDto] }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [category_dto_1.GetCategoryBySlugQueryDto]),
    __metadata("design:returntype", void 0)
], CategoryController.prototype, "getBySlug", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update a category by ID' }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto,
        category_dto_1.UpdateCategoryDto, Object]),
    __metadata("design:returntype", void 0)
], CategoryController.prototype, "updateByID", null);
exports.CategoryController = CategoryController = __decorate([
    (0, swagger_1.ApiTags)(exports.CategoryRoutePath.tag),
    (0, common_1.Controller)(exports.CategoryRoutePath.path),
    __metadata("design:paramtypes", [category_service_1.CategoryService])
], CategoryController);
//# sourceMappingURL=category.controller.js.map